/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.service;

import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;

public abstract class AnnotationProcessor<T extends Annotation> {
    private static final Logger log = LoggerFactory.getLogger(AnnotationProcessor.class);
    private static final String BASE_PACKAGE = "app.peac";

    protected abstract Class<T> getAnnotationType();

    protected abstract void initializeAnnotation(String var1);

    protected void beforeAllAnnotations(Set<String> classes) {
        log.info("Found {} classes with '{}' annotation", (Object)classes.size(), (Object)this.getAnnotationType().getSimpleName());
    }

    protected void initialize() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter(new AnnotationTypeFilter(this.getAnnotationType()));
        Set<String> allClassesWithAnnotation = scanner.findCandidateComponents(BASE_PACKAGE).stream().map(BeanDefinition::getBeanClassName).collect(Collectors.toSet());
        this.beforeAllAnnotations(allClassesWithAnnotation);
        allClassesWithAnnotation.forEach(this::initializeAnnotation);
        this.afterAllAnnotations(allClassesWithAnnotation);
    }

    protected void afterAllAnnotations(Set<String> classes) {
        log.info("{} classes processed with '{}' annotation", (Object)classes.size(), (Object)this.getAnnotationType().getSimpleName());
    }
}

