/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.service.rpa;

import app.peac.core.model.rpa.RpaDriverConfig;
import app.peac.core.utils.rpa.driver.ChromeDriverUtils;
import app.peac.core.utils.rpa.driver.EdgeDriverUtils;
import app.peac.core.utils.rpa.driver.FirefoxDriverUtils;
import app.peac.core.utils.rpa.driver.SafariDriverUtils;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpaDriver
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RpaDriver.class);
    private static final String JS_SCRIPT_TO_GET_SCROLL_HEIGHT = "return document.body.scrollHeight;";
    private static final Random random = new Random();
    private final RpaDriverConfig config;
    private final WebDriver driver;
    private final Actions actions;

    public RpaDriver(RpaDriverConfig config) {
        if (Objects.isNull(config)) {
            throw new IllegalArgumentException("Configuration of RpaDriver shouldn't be null");
        }
        log.info("Creating new RpaDriver for {}", (Object)config.getDriverType().name());
        this.config = config;
        switch (config.getDriverType()) {
            case EDGE: {
                this.driver = EdgeDriverUtils.createEdgeDriver(config);
                break;
            }
            case FIREFOX: {
                this.driver = FirefoxDriverUtils.createFirefoxDriver(config);
                break;
            }
            case SAFARI: {
                this.driver = SafariDriverUtils.createSafariDriver();
                break;
            }
            default: {
                this.driver = ChromeDriverUtils.createChromeDriver(config);
            }
        }
        log.info("{} RpaDriver created, adding additional settings", (Object)config.getDriverType().name());
        this.driver.manage().timeouts().implicitlyWait(Duration.ofSeconds(10L)).pageLoadTimeout(Duration.ofMinutes(1L)).scriptTimeout(Duration.ofMinutes(1L));
        this.driver.manage().window().maximize();
        this.actions = new Actions(this.driver);
        log.info("{} RpaDriver is ready", (Object)config.getDriverType().name());
    }

    public void openBrowserOn(String url) {
        int counter = 0;
        long maxWaitInSec = this.driver.manage().timeouts().getPageLoadTimeout().getSeconds();
        while ((long)counter < maxWaitInSec) {
            try {
                this.driver.get(url);
                break;
            }
            catch (UnreachableBrowserException e) {
                log.warn("Restarting browser due to exception: {}", (Object)e.getMessage());
                this.waitForSec(1L);
                ++counter;
            }
        }
    }

    public void waitForMilliSec(long ms) {
        this.waitFor(TimeUnit.MILLISECONDS, ms);
    }

    public void waitForSec(long seconds) {
        this.waitFor(TimeUnit.SECONDS, seconds);
    }

    public void waitFor(TimeUnit unit, long amount) {
        try {
            unit.sleep(amount);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
        }
    }

    public void imitateUserWait() {
        this.waitForMilliSec(random.nextLong(1001L, 1999L));
    }

    public WebElement findBy(By selector) {
        return this.driver.findElement(selector);
    }

    public WebElement findBy(ExpectedCondition<WebElement> condition) {
        return this.findBy(Duration.ofMinutes(1L), condition);
    }

    public WebElement findBy(Duration duration, ExpectedCondition<WebElement> condition) {
        return (WebElement)new WebDriverWait(this.driver, duration).until(condition);
    }

    public Boolean check(ExpectedCondition<Boolean> condition) {
        return (Boolean)new WebDriverWait(this.driver, Duration.ofMinutes(1L)).until(condition);
    }

    public List<WebElement> findAllBy(By selector) {
        return this.driver.findElements(selector);
    }

    public List<WebElement> findAllBy(ExpectedCondition<List<WebElement>> condition) {
        return this.findAllBy(Duration.ofMinutes(1L), condition);
    }

    public List<WebElement> findAllBy(Duration duration, ExpectedCondition<List<WebElement>> condition) {
        return (List)new WebDriverWait(this.driver, duration).until(condition);
    }

    public void clickOnElemBy(By locator) {
        this.findBy(ExpectedConditions.elementToBeClickable(locator)).click();
    }

    public void sendKeysBy(By locator, String value) {
        this.findBy(ExpectedConditions.elementToBeClickable(locator)).sendKeys(value);
    }

    private void sendKeys(Object text) {
        this.actions.sendKeys((CharSequence)text);
    }

    public void pressKey(Keys key) {
        this.sendKeys(key);
    }

    public void pressKeys(Keys ... keys) {
        this.sendKeys(Keys.chord(keys));
    }

    public void scrollToPageBottom() {
        this.executeJS("window.scrollTo(0,document.body.scrollHeight);");
    }

    public void scrollToPageBottomWithRefreshCheck() {
        long currentHeight;
        do {
            currentHeight = (Long)this.executeJS(JS_SCRIPT_TO_GET_SCROLL_HEIGHT);
            this.scrollToPageBottom();
            this.imitateUserWait();
        } while (currentHeight != (Long)this.executeJS(JS_SCRIPT_TO_GET_SCROLL_HEIGHT));
        this.scrollToPageBottom();
        this.imitateUserWait();
        if (currentHeight != (Long)this.executeJS(JS_SCRIPT_TO_GET_SCROLL_HEIGHT)) {
            this.scrollToPageBottomWithRefreshCheck();
        }
    }

    public WebElement moveToElement(By locator) {
        WebElement elem = this.findBy(locator);
        this.actions.moveToElement(elem).perform();
        return elem;
    }

    public void refreshPage() {
        this.driver.navigate().refresh();
    }

    public <T> T executeJS(String script) {
        return this.executeJS(script, false);
    }

    public <T> T executeJS(String script, boolean enableLog) {
        String logMsg = "Execute Java Script:\r\n" + script.substring(0, Math.min(1000, script.length()));
        try {
            if (enableLog && log.isDebugEnabled()) {
                log.debug(logMsg);
            }
            return (T)((JavascriptExecutor)((Object)this.driver)).executeScript(script, new Object[0]);
        }
        catch (Exception e) {
            if (enableLog) {
                log.error(logMsg, e);
            }
            throw e;
        }
    }

    @Override
    public void close() {
        try {
            this.driver.quit();
        }
        catch (IllegalStateException e) {
            log.error("Driver cannot be closed: {}", (Object)e.getMessage());
        }
    }

    public RpaDriverConfig getConfig() {
        return this.config;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public Actions getActions() {
        return this.actions;
    }
}

