/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.utils.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ZipHelper {
    private static final int BUFFER_SIZE = 4096;

    public static void unzip(byte[] data, String dirName) throws IOException {
        File destDir = new File(dirName);
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try (ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(data));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String filePath = dirName + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    ZipHelper.extractFile(zipIn, filePath);
                } else {
                    File dir = new File(filePath);
                    dir.mkdirs();
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    private ZipHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

