/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.utils.rpa;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.concurrent.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RpaThreadUtils {
    private static final Logger log = LoggerFactory.getLogger(RpaThreadUtils.class);
    private static final ExecutorService THREADS = Executors.newSingleThreadExecutor();
    private static Future<?> currentFuture;

    public static synchronized Future<?> createRpaThread(Task<?> task) {
        log.info("Creating new RPA thread");
        if (currentFuture != null) {
            log.info("Previous RPA thread is still running");
            currentFuture.cancel(true);
            log.info("Previous RPA thread cancelled");
        }
        currentFuture = THREADS.submit(task);
        log.info("New RPA thread created");
        return currentFuture;
    }

    private RpaThreadUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

