/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.utils.rpa.driver;

import app.peac.core.model.rpa.RpaDriverConfig;
import app.peac.core.utils.rpa.driver.ChromiumDriverUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ChromeDriverUtils {
    private static final Logger log = LoggerFactory.getLogger(ChromeDriverUtils.class);

    public static WebDriver createChromeDriver(RpaDriverConfig config) {
        log.info("Creating ChromeDriver");
        log.info("RunHeadless: {}", (Object)config.isRunHeadless());
        ChromeOptions options = new ChromeOptions();
        options.addArguments(ChromiumDriverUtils.getCommonDriverOptions());
        if (config.isUserDataExists()) {
            options.addArguments("user-data-dir=" + config.getUserDataPath());
        }
        if (config.isRunHeadless()) {
            options.addArguments("--headless");
        } else {
            options.addArguments("--start-maximized");
        }
        log.info("Chrome Driver Options are ready");
        return new ChromeDriver(options);
    }

    private ChromeDriverUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

