/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.utils.rpa.driver;

import app.peac.core.model.rpa.RpaDriverConfig;
import app.peac.core.utils.rpa.driver.ChromiumDriverUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EdgeDriverUtils {
    private static final Logger log = LoggerFactory.getLogger(EdgeDriverUtils.class);

    public static WebDriver createEdgeDriver(RpaDriverConfig config) {
        log.info("Creating EdgeDriver");
        log.info("UserDataPath: {}", (Object)config.getUserDataPath());
        log.info("RunHeadless: {}", (Object)config.isRunHeadless());
        EdgeOptions options = new EdgeOptions();
        options.addArguments(ChromiumDriverUtils.getCommonDriverOptions());
        if (config.isUserDataExists()) {
            options.addArguments("user-data-dir=" + config.getUserDataPath());
        }
        if (config.isRunHeadless()) {
            options.addArguments("--headless");
        } else {
            options.addArguments("--start-maximized");
        }
        log.info("Edge Driver Options are ready");
        return new EdgeDriver(options);
    }

    private EdgeDriverUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

