/*
 * Decompiled with CFR 0.152.
 */
package app.peac.core.utils.rpa.driver;

import app.peac.core.model.rpa.RpaDriverConfig;
import java.io.File;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FirefoxDriverUtils {
    private static final Logger log = LoggerFactory.getLogger(FirefoxDriverUtils.class);

    public static WebDriver createFirefoxDriver(RpaDriverConfig config) {
        log.info("Creating ChromeDriver");
        log.info("UserDataPath: {}", (Object)config.getUserDataPath());
        log.info("RunHeadless: {}", (Object)config.isRunHeadless());
        FirefoxOptions options = new FirefoxOptions();
        if (config.isUserDataExists()) {
            File profileDir = new File(config.getUserDataPath());
            FirefoxProfile profile2 = new FirefoxProfile(profileDir);
            profile2.setAcceptUntrustedCertificates(true);
            options.setProfile(profile2);
        }
        if (config.isRunHeadless()) {
            options.addArguments("-headless");
        }
        log.info("Firefox Driver Options are ready");
        return new FirefoxDriver(options);
    }

    private FirefoxDriverUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

