/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.security.ProtectionDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdmAgent {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private WdmAgent() {
        throw new IllegalStateException("WebDriverManager agent is used for static instrumentation");
    }

    public static void premain(String args, Instrumentation instrumentation) {
        instrumentation.addTransformer(new DefineTransformer(), true);
    }

    static class DefineTransformer
    implements ClassFileTransformer {
        DefineTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            DriverManagerType driverManagerType = null;
            switch (className) {
                case "org/openqa/selenium/chrome/ChromeDriver": {
                    driverManagerType = DriverManagerType.CHROME;
                    break;
                }
                case "org/openqa/selenium/firefox/FirefoxDriver": {
                    driverManagerType = DriverManagerType.FIREFOX;
                    break;
                }
                case "org/openqa/selenium/opera/OperaDriver": {
                    driverManagerType = DriverManagerType.OPERA;
                    break;
                }
                case "org/openqa/selenium/edge/EdgeDriver": {
                    driverManagerType = DriverManagerType.EDGE;
                    break;
                }
                case "org/openqa/selenium/ie/InternetExplorerDriver": {
                    driverManagerType = DriverManagerType.IEXPLORER;
                    break;
                }
            }
            if (driverManagerType != null) {
                log.debug("WebDriverManager Agent is going to resolve the driver for {}", (Object)driverManagerType);
                WebDriverManager.getInstance(driverManagerType).setup();
            }
            return classfileBuffer;
        }
    }
}

