/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.webdriver;

import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverCreator {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final int POLL_TIME_SEC = 1;
    Config config;

    public WebDriverCreator(Config config) {
        this.config = config;
    }

    public synchronized WebDriver createLocalWebDriver(Class<?> browserClass, Capabilities capabilities) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        WebDriver driver = capabilities != null ? (WebDriver)browserClass.getDeclaredConstructor(capabilities.getClass()).newInstance(capabilities) : (WebDriver)browserClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return driver;
    }

    public WebDriver createRemoteWebDriver(String remoteUrl, Capabilities capabilities) {
        RemoteWebDriver webdriver = null;
        int waitTimeoutSec = this.config.getTimeout();
        long timeoutMs = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(waitTimeoutSec);
        String browserName = capabilities.getBrowserName();
        this.log.debug("Creating WebDriver object for {} at {} with {}", browserName, remoteUrl, capabilities);
        do {
            try {
                URL url = new URL(remoteUrl);
                HttpURLConnection huc = (HttpURLConnection)url.openConnection();
                huc.connect();
                int responseCode = huc.getResponseCode();
                this.log.trace("Requesting {} (the response code is {})", (Object)remoteUrl, (Object)responseCode);
                webdriver = new RemoteWebDriver(url, capabilities);
            }
            catch (Exception e1) {
                try {
                    this.log.trace("{} creating WebDriver object ({})", (Object)e1.getClass().getSimpleName(), (Object)e1.getMessage());
                    if (System.currentTimeMillis() > timeoutMs) {
                        throw new WebDriverManagerException("Timeout of " + waitTimeoutSec + " seconds creating WebDriver object", e1);
                    }
                    Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                }
                catch (InterruptedException e2) {
                    this.log.warn("Interrupted exception creating WebDriver object", e2);
                    Thread.currentThread().interrupt();
                }
            }
        } while (webdriver == null);
        return webdriver;
    }

    public String getSessionId(WebDriver webDriver) {
        String sessionId = ((RemoteWebDriver)webDriver).getSessionId().toString();
        this.log.debug("The sessionId is {}", (Object)sessionId);
        return sessionId;
    }
}

