/*
 * Decompiled with CFR 0.152.
 */
package io.ous.jtoml;

import io.ous.jtoml.impl.ObjectDeserializer;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TomlTable
extends HashMap<String, Object> {
    public Object get(String key, Object ... keys) throws IllegalArgumentException {
        Object value = this.get(key);
        if (keys != null) {
            for (Object key2 : keys) {
                if (value instanceof TomlTable) {
                    value = ((TomlTable)value).get(key2);
                    continue;
                }
                if (value instanceof List && key2 instanceof Integer) {
                    value = ((List)value).get((Integer)key2);
                    continue;
                }
                throw new IllegalArgumentException(key2 + " is not a valid property under a " + value.getClass().getName());
            }
        }
        return value;
    }

    public Object getValue(String bar, Object ... keys) {
        return this.get(bar, keys);
    }

    public String getString(String name, Object ... keys) throws ClassCastException {
        return (String)this.get(name, keys);
    }

    public Long getLong(String name, Object ... keys) throws ClassCastException {
        return (Long)this.get(name, keys);
    }

    public Double getDouble(String name, Object ... keys) throws ClassCastException {
        return (Double)this.get(name, keys);
    }

    public Date getDate(String name, Object ... keys) throws ClassCastException {
        return (Date)this.get(name, keys);
    }

    public List<?> getList(String name, Object ... keys) throws ClassCastException {
        return (List)this.get(name, keys);
    }

    public List<TomlTable> getArrayTable(String name, Object ... keys) throws ClassCastException {
        return (List)this.get(name, keys);
    }

    public Boolean getBoolean(String name, Object ... keys) throws ClassCastException {
        return (Boolean)this.get(name, keys);
    }

    public TomlTable getTomlTable(String name, Object ... keys) throws ClassCastException {
        return (TomlTable)this.get(name, keys);
    }

    public <T extends Enum<T>> T getAsEnum(Class<T> type, String name, Object ... keys) {
        Object value = this.get(name, keys);
        return ObjectDeserializer.getInstance().toEnum(type, value);
    }

    public <T> T asObject(Class<T> type) {
        return ObjectDeserializer.getInstance().create(type, this);
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this);
    }
}

