/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.PlusMinusSliderSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.collections.MapChangeListener;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.InputEvent;
import org.controlsfx.control.ControlsFXControl;

public class PlusMinusSlider
extends ControlsFXControl {
    private static final String DEFAULT_STYLE_CLASS = "plus-minus-slider";
    private static final PseudoClass VERTICAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("vertical");
    private static final PseudoClass HORIZONTAL_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("horizontal");
    private ReadOnlyDoubleWrapper value = new ReadOnlyDoubleWrapper(this, "value", 0.0);
    private ObjectProperty<Orientation> orientation;
    private ObjectProperty<EventHandler<PlusMinusEvent>> onValueChanged = new ObjectPropertyBase<EventHandler<PlusMinusEvent>>(){

        @Override
        protected void invalidated() {
            PlusMinusSlider.this.setEventHandler(PlusMinusEvent.VALUE_CHANGED, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return PlusMinusSlider.this;
        }

        @Override
        public String getName() {
            return "onValueChanged";
        }
    };

    public PlusMinusSlider() {
        this.getStyleClass().add(DEFAULT_STYLE_CLASS);
        this.setOrientation(Orientation.HORIZONTAL);
        this.getProperties().addListener(new MapChangeListener<Object, Object>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                if (change.getKey().equals("plusminusslidervalue") && change.getValueAdded() != null) {
                    Double valueAdded = (Double)change.getValueAdded();
                    PlusMinusSlider.this.value.set(valueAdded);
                    change.getMap().remove("plusminusslidervalue");
                }
            }
        });
    }

    @Override
    public String getUserAgentStylesheet() {
        return this.getUserAgentStylesheet(PlusMinusSlider.class, "plusminusslider.css");
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new PlusMinusSliderSkin(this);
    }

    public final ReadOnlyDoubleProperty valueProperty() {
        return this.value.getReadOnlyProperty();
    }

    public final double getValue() {
        return this.valueProperty().get();
    }

    public final void setOrientation(Orientation value) {
        this.orientationProperty().set(value);
    }

    public final Orientation getOrientation() {
        return this.orientation == null ? Orientation.HORIZONTAL : (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        if (this.orientation == null) {
            this.orientation = new StyleableObjectProperty<Orientation>(null){

                @Override
                protected void invalidated() {
                    boolean vertical = this.get() == Orientation.VERTICAL;
                    PlusMinusSlider.this.pseudoClassStateChanged(VERTICAL_PSEUDOCLASS_STATE, vertical);
                    PlusMinusSlider.this.pseudoClassStateChanged(HORIZONTAL_PSEUDOCLASS_STATE, !vertical);
                }

                @Override
                public CssMetaData<PlusMinusSlider, Orientation> getCssMetaData() {
                    return StyleableProperties.ORIENTATION;
                }

                @Override
                public Object getBean() {
                    return PlusMinusSlider.this;
                }

                @Override
                public String getName() {
                    return "orientation";
                }
            };
        }
        return this.orientation;
    }

    public final ObjectProperty<EventHandler<PlusMinusEvent>> onValueChangedProperty() {
        return this.onValueChanged;
    }

    public final void setOnValueChanged(EventHandler<PlusMinusEvent> value) {
        this.onValueChangedProperty().set(value);
    }

    public final EventHandler<PlusMinusEvent> getOnValueChanged() {
        return (EventHandler)this.onValueChangedProperty().get();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return PlusMinusSlider.getClassCssMetaData();
    }

    public static class PlusMinusEvent
    extends InputEvent {
        private static final long serialVersionUID = 2881004583512990781L;
        public static final EventType<PlusMinusEvent> ANY = new EventType<InputEvent>(InputEvent.ANY, "ANY" + UUID.randomUUID().toString());
        public static final EventType<PlusMinusEvent> VALUE_CHANGED = new EventType<PlusMinusEvent>(ANY, "VALUE_CHANGED" + UUID.randomUUID().toString());
        private double value;

        public PlusMinusEvent(Object source, EventTarget target, EventType<? extends InputEvent> eventType, double value) {
            super(source, target, eventType);
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<PlusMinusSlider, Orientation> ORIENTATION = new CssMetaData<PlusMinusSlider, Orientation>("-fx-orientation", new EnumConverter<Orientation>(Orientation.class), Orientation.VERTICAL){

            @Override
            public Orientation getInitialValue(PlusMinusSlider node) {
                return node.getOrientation();
            }

            @Override
            public boolean isSettable(PlusMinusSlider n) {
                return n.orientation == null || !n.orientation.isBound();
            }

            @Override
            public StyleableProperty<Orientation> getStyleableProperty(PlusMinusSlider n) {
                return (StyleableProperty)((Object)n.orientationProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.add(ORIENTATION);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

