/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Objects;
import javafx.event.ActionEvent;
import org.controlsfx.control.action.Action;

public class AnnotatedAction
extends Action {
    private final Method method;
    private final WeakReference<Object> target;

    public AnnotatedAction(String text, Method method, Object target) {
        super(text);
        Objects.requireNonNull(method);
        Objects.requireNonNull(target);
        this.setEventHandler(this::handleAction);
        this.method = method;
        this.method.setAccessible(true);
        this.target = new WeakReference<Object>(target);
    }

    public Object getTarget() {
        return this.target.get();
    }

    protected void handleAction(ActionEvent ae) {
        try {
            Object actionTarget = this.getTarget();
            if (actionTarget == null) {
                throw new IllegalStateException("Action target object is no longer reachable");
            }
            int paramCount = this.method.getParameterCount();
            if (paramCount == 0) {
                this.method.invoke(actionTarget, new Object[0]);
            } else if (paramCount == 1) {
                this.method.invoke(actionTarget, ae);
            } else if (paramCount == 2) {
                this.method.invoke(actionTarget, ae, this);
            }
        }
        catch (Throwable e) {
            this.handleActionException(ae, e);
        }
    }

    protected void handleActionException(ActionEvent ae, Throwable ex) {
        ex.printStackTrace();
    }

    public String toString() {
        return this.getText();
    }
}

