/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.function.Predicate;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.BeanProperty;

public final class BeanPropertyUtils {
    private BeanPropertyUtils() {
    }

    public static ObservableList<PropertySheet.Item> getProperties(Object bean2) {
        return BeanPropertyUtils.getProperties(bean2, p -> true);
    }

    public static ObservableList<PropertySheet.Item> getProperties(Object bean2, Predicate<PropertyDescriptor> test) {
        ObservableList<PropertySheet.Item> list = FXCollections.observableArrayList();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean2.getClass(), Object.class);
            for (PropertyDescriptor p : beanInfo.getPropertyDescriptors()) {
                if (!test.test(p)) continue;
                list.add(new BeanProperty(bean2, p));
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        return list;
    }
}

