/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriverLogLevel;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumDriverLogLevel;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriverService
extends DriverService {
    public static final String CHROME_DRIVER_NAME = "chromedriver";
    public static final String CHROME_DRIVER_EXE_PROPERTY = "webdriver.chrome.driver";
    public static final String CHROME_DRIVER_READABLE_TIMESTAMP = "webdriver.chrome.readableTimestamp";
    public static final String CHROME_DRIVER_LOG_PROPERTY = "webdriver.chrome.logfile";
    public static final String CHROME_DRIVER_LOG_LEVEL_PROPERTY = "webdriver.chrome.loglevel";
    public static final String CHROME_DRIVER_APPEND_LOG_PROPERTY = "webdriver.chrome.appendLog";
    public static final String CHROME_DRIVER_VERBOSE_LOG_PROPERTY = "webdriver.chrome.verboseLogging";
    public static final String CHROME_DRIVER_SILENT_OUTPUT_PROPERTY = "webdriver.chrome.silentOutput";
    public static final String CHROME_DRIVER_ALLOWED_IPS_PROPERTY = "webdriver.chrome.withAllowedIps";
    @Deprecated
    public static final String CHROME_DRIVER_WHITELISTED_IPS_PROPERTY = "webdriver.chrome.whitelistedIps";
    public static final String CHROME_DRIVER_DISABLE_BUILD_CHECK = "webdriver.chrome.disableBuildCheck";

    public ChromeDriverService(File executable, int port, List<String> args, Map<String, String> environment2) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment2)));
    }

    public ChromeDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment2) throws IOException {
        super(executable, port, timeout, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment2)));
    }

    @Override
    public String getDriverName() {
        return CHROME_DRIVER_NAME;
    }

    @Override
    public String getDriverProperty() {
        return CHROME_DRIVER_EXE_PROPERTY;
    }

    @Override
    public Capabilities getDefaultDriverOptions() {
        return new ChromeOptions();
    }

    public static ChromeDriverService createDefaultService() {
        return (ChromeDriverService)new Builder().build();
    }

    @Deprecated
    public static ChromeDriverService createServiceWithConfig(ChromeOptions options) {
        ChromeDriverLogLevel oldLevel = options.getLogLevel();
        ChromiumDriverLogLevel level = oldLevel == null ? null : ChromiumDriverLogLevel.fromString(oldLevel.toString());
        return (ChromeDriverService)new Builder().withLogLevel(level).build();
    }

    static boolean isPresent() {
        return ChromeDriverService.findExePath(CHROME_DRIVER_NAME, CHROME_DRIVER_EXE_PROPERTY) != null;
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<ChromeDriverService, Builder> {
        private boolean disableBuildCheck = Boolean.getBoolean("webdriver.chrome.disableBuildCheck");
        private boolean readableTimestamp = Boolean.getBoolean("webdriver.chrome.readableTimestamp");
        private boolean appendLog = Boolean.getBoolean("webdriver.chrome.appendLog");
        private boolean verbose = Boolean.getBoolean("webdriver.chrome.verboseLogging");
        private boolean silent = Boolean.getBoolean("webdriver.chrome.silentOutput");
        private String allowedListIps = System.getProperty("webdriver.chrome.withAllowedIps", System.getProperty("webdriver.chrome.whitelistedIps"));
        private ChromiumDriverLogLevel logLevel = ChromiumDriverLogLevel.fromString(System.getProperty("webdriver.chrome.loglevel"));

        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.CHROME.is(capabilities.getBrowserName())) {
                ++score;
            }
            if (capabilities.getCapability("goog:chromeOptions") != null) {
                ++score;
            }
            return score;
        }

        public Builder withAppendLog(boolean appendLog) {
            this.appendLog = appendLog;
            return this;
        }

        public Builder withBuildCheckDisabled(boolean noBuildCheck) {
            this.disableBuildCheck = noBuildCheck;
            return this;
        }

        public Builder withVerbose(boolean verbose) {
            if (verbose) {
                this.logLevel = ChromiumDriverLogLevel.ALL;
            }
            this.verbose = false;
            return this;
        }

        @Deprecated
        public Builder withLogLevel(ChromeDriverLogLevel logLevel) {
            this.verbose = false;
            this.silent = false;
            this.logLevel = ChromiumDriverLogLevel.fromString(logLevel.toString());
            return this;
        }

        public Builder withLogLevel(ChromiumDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withSilent(boolean silent) {
            if (silent) {
                this.logLevel = ChromiumDriverLogLevel.OFF;
            }
            this.silent = false;
            return this;
        }

        @Deprecated
        public Builder withWhitelistedIps(String allowedListIps) {
            this.allowedListIps = allowedListIps;
            return this;
        }

        public Builder withAllowedListIps(String allowedListIps) {
            this.allowedListIps = allowedListIps;
            return this;
        }

        public Builder withReadableTimestamp(Boolean readableTimestamp) {
            this.readableTimestamp = readableTimestamp;
            return this;
        }

        @Override
        protected List<String> createArgs() {
            String logFilePath;
            if (this.getLogFile() == null && (logFilePath = System.getProperty(ChromeDriverService.CHROME_DRIVER_LOG_PROPERTY)) != null) {
                this.withLogFile(new File(logFilePath));
            }
            if (this.verbose) {
                this.withVerbose(true);
            }
            if (this.silent) {
                this.withSilent(true);
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                args.add(String.format("--log-path=%s", this.getLogFile().getAbsolutePath()));
                if (this.readableTimestamp) {
                    args.add("--readable-timestamp");
                }
            }
            if (this.appendLog) {
                args.add("--append-log");
            }
            if (this.logLevel != null) {
                args.add(String.format("--log-level=%s", this.logLevel.toString().toUpperCase()));
            }
            if (this.allowedListIps != null) {
                args.add(String.format("--allowed-ips=%s", this.allowedListIps));
            }
            if (this.disableBuildCheck) {
                args.add("--disable-build-check");
            }
            return Collections.unmodifiableList(args);
        }

        @Override
        protected ChromeDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment2) {
            try {
                return new ChromeDriverService(exe, port, timeout, args, environment2);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

