/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chromium;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chromium.HasCasting;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;

public abstract class AddHasCasting
implements AugmenterProvider<HasCasting>,
AdditionalHttpCommands {
    public static final String GET_CAST_SINKS = "getCastSinks";
    public static final String SET_CAST_SINK_TO_USE = "selectCastSink";
    public static final String START_CAST_TAB_MIRRORING = "startCastTabMirroring";
    public static final String START_CAST_DESKTOP_MIRRORING = "startDesktopMirroring";
    public static final String GET_CAST_ISSUE_MESSAGE = "getCastIssueMessage";
    public static final String STOP_CASTING = "stopCasting";

    @Override
    public abstract Map<String, CommandInfo> getAdditionalCommands();

    @Override
    public abstract Predicate<Capabilities> isApplicable();

    @Override
    public Class<HasCasting> getDescribedInterface() {
        return HasCasting.class;
    }

    @Override
    public HasCasting getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasCasting(){

            @Override
            public List<Map<String, String>> getCastSinks() {
                return (List)executeMethod.execute(AddHasCasting.GET_CAST_SINKS, null);
            }

            @Override
            public void selectCastSink(String deviceName) {
                Require.nonNull("Device Name", deviceName);
                executeMethod.execute(AddHasCasting.SET_CAST_SINK_TO_USE, ImmutableMap.of("sinkName", deviceName));
            }

            @Override
            public void startDesktopMirroring(String deviceName) {
                Require.nonNull("Device Name", deviceName);
                executeMethod.execute(AddHasCasting.START_CAST_DESKTOP_MIRRORING, ImmutableMap.of("sinkName", deviceName));
            }

            @Override
            public void startTabMirroring(String deviceName) {
                Require.nonNull("Device Name", deviceName);
                executeMethod.execute(AddHasCasting.START_CAST_TAB_MIRRORING, ImmutableMap.of("sinkName", deviceName));
            }

            @Override
            public String getCastIssueMessage() {
                return executeMethod.execute(AddHasCasting.GET_CAST_ISSUE_MESSAGE, null).toString();
            }

            @Override
            public void stopCasting(String deviceName) {
                Require.nonNull("Device Name", deviceName);
                executeMethod.execute(AddHasCasting.STOP_CASTING, ImmutableMap.of("sinkName", deviceName));
            }
        };
    }
}

