/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.debugger.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum ScriptLanguage {
    JAVASCRIPT("JavaScript"),
    WEBASSEMBLY("WebAssembly");

    private String value;

    private ScriptLanguage(String value) {
        this.value = value;
    }

    public static ScriptLanguage fromString(String s2) {
        return Arrays.stream(ScriptLanguage.values()).filter(rs -> rs.value.equalsIgnoreCase(s2)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s2 + " is not found within ScriptLanguage "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static ScriptLanguage fromJson(JsonInput input) {
        return ScriptLanguage.fromString(input.nextString());
    }
}

