/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.dom.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.json.JsonInput;

public class RGBA {
    private final Integer r;
    private final Integer g;
    private final Integer b;
    private final Optional<Number> a;

    public RGBA(Integer r, Integer g2, Integer b, Optional<Number> a) {
        this.r = Objects.requireNonNull(r, "r is required");
        this.g = Objects.requireNonNull(g2, "g is required");
        this.b = Objects.requireNonNull(b, "b is required");
        this.a = a;
    }

    public Integer getR() {
        return this.r;
    }

    public Integer getG() {
        return this.g;
    }

    public Integer getB() {
        return this.b;
    }

    public Optional<Number> getA() {
        return this.a;
    }

    private static RGBA fromJson(JsonInput input) {
        Integer r = 0;
        Integer g2 = 0;
        Integer b = 0;
        Optional<Number> a = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "r": {
                    r = input.nextNumber().intValue();
                    continue block12;
                }
                case "g": {
                    g2 = input.nextNumber().intValue();
                    continue block12;
                }
                case "b": {
                    b = input.nextNumber().intValue();
                    continue block12;
                }
                case "a": {
                    a = Optional.ofNullable(input.nextNumber());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new RGBA(r, g2, b, a);
    }
}

