/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.layertree.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v110.dom.model.Rect;
import org.openqa.selenium.devtools.v110.layertree.model.LayerId;
import org.openqa.selenium.json.JsonInput;

public class StickyPositionConstraint {
    private final Rect stickyBoxRect;
    private final Rect containingBlockRect;
    private final Optional<LayerId> nearestLayerShiftingStickyBox;
    private final Optional<LayerId> nearestLayerShiftingContainingBlock;

    public StickyPositionConstraint(Rect stickyBoxRect, Rect containingBlockRect, Optional<LayerId> nearestLayerShiftingStickyBox, Optional<LayerId> nearestLayerShiftingContainingBlock) {
        this.stickyBoxRect = Objects.requireNonNull(stickyBoxRect, "stickyBoxRect is required");
        this.containingBlockRect = Objects.requireNonNull(containingBlockRect, "containingBlockRect is required");
        this.nearestLayerShiftingStickyBox = nearestLayerShiftingStickyBox;
        this.nearestLayerShiftingContainingBlock = nearestLayerShiftingContainingBlock;
    }

    public Rect getStickyBoxRect() {
        return this.stickyBoxRect;
    }

    public Rect getContainingBlockRect() {
        return this.containingBlockRect;
    }

    public Optional<LayerId> getNearestLayerShiftingStickyBox() {
        return this.nearestLayerShiftingStickyBox;
    }

    public Optional<LayerId> getNearestLayerShiftingContainingBlock() {
        return this.nearestLayerShiftingContainingBlock;
    }

    private static StickyPositionConstraint fromJson(JsonInput input) {
        Rect stickyBoxRect = null;
        Rect containingBlockRect = null;
        Optional<LayerId> nearestLayerShiftingStickyBox = Optional.empty();
        Optional<LayerId> nearestLayerShiftingContainingBlock = Optional.empty();
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "stickyBoxRect": {
                    stickyBoxRect = (Rect)input.read((Type)((Object)Rect.class));
                    continue block12;
                }
                case "containingBlockRect": {
                    containingBlockRect = (Rect)input.read((Type)((Object)Rect.class));
                    continue block12;
                }
                case "nearestLayerShiftingStickyBox": {
                    nearestLayerShiftingStickyBox = Optional.ofNullable((LayerId)input.read((Type)((Object)LayerId.class)));
                    continue block12;
                }
                case "nearestLayerShiftingContainingBlock": {
                    nearestLayerShiftingContainingBlock = Optional.ofNullable((LayerId)input.read((Type)((Object)LayerId.class)));
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new StickyPositionConstraint(stickyBoxRect, containingBlockRect, nearestLayerShiftingStickyBox, nearestLayerShiftingContainingBlock);
    }
}

