/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.network;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v110.debugger.model.SearchMatch;
import org.openqa.selenium.devtools.v110.emulation.model.UserAgentMetadata;
import org.openqa.selenium.devtools.v110.io.model.StreamHandle;
import org.openqa.selenium.devtools.v110.network.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.v110.network.model.ConnectionType;
import org.openqa.selenium.devtools.v110.network.model.ContentEncoding;
import org.openqa.selenium.devtools.v110.network.model.Cookie;
import org.openqa.selenium.devtools.v110.network.model.CookieParam;
import org.openqa.selenium.devtools.v110.network.model.CookiePriority;
import org.openqa.selenium.devtools.v110.network.model.CookieSameSite;
import org.openqa.selenium.devtools.v110.network.model.CookieSourceScheme;
import org.openqa.selenium.devtools.v110.network.model.DataReceived;
import org.openqa.selenium.devtools.v110.network.model.ErrorReason;
import org.openqa.selenium.devtools.v110.network.model.EventSourceMessageReceived;
import org.openqa.selenium.devtools.v110.network.model.Headers;
import org.openqa.selenium.devtools.v110.network.model.InterceptionId;
import org.openqa.selenium.devtools.v110.network.model.LoadNetworkResourceOptions;
import org.openqa.selenium.devtools.v110.network.model.LoadNetworkResourcePageResult;
import org.openqa.selenium.devtools.v110.network.model.LoadingFailed;
import org.openqa.selenium.devtools.v110.network.model.LoadingFinished;
import org.openqa.selenium.devtools.v110.network.model.ReportingApiEndpointsChangedForOrigin;
import org.openqa.selenium.devtools.v110.network.model.ReportingApiReport;
import org.openqa.selenium.devtools.v110.network.model.RequestId;
import org.openqa.selenium.devtools.v110.network.model.RequestIntercepted;
import org.openqa.selenium.devtools.v110.network.model.RequestPattern;
import org.openqa.selenium.devtools.v110.network.model.RequestWillBeSent;
import org.openqa.selenium.devtools.v110.network.model.RequestWillBeSentExtraInfo;
import org.openqa.selenium.devtools.v110.network.model.ResourceChangedPriority;
import org.openqa.selenium.devtools.v110.network.model.ResponseReceived;
import org.openqa.selenium.devtools.v110.network.model.ResponseReceivedExtraInfo;
import org.openqa.selenium.devtools.v110.network.model.SecurityIsolationStatus;
import org.openqa.selenium.devtools.v110.network.model.SignedExchangeReceived;
import org.openqa.selenium.devtools.v110.network.model.SubresourceWebBundleInnerResponseError;
import org.openqa.selenium.devtools.v110.network.model.SubresourceWebBundleInnerResponseParsed;
import org.openqa.selenium.devtools.v110.network.model.SubresourceWebBundleMetadataError;
import org.openqa.selenium.devtools.v110.network.model.SubresourceWebBundleMetadataReceived;
import org.openqa.selenium.devtools.v110.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v110.network.model.TrustTokenOperationDone;
import org.openqa.selenium.devtools.v110.network.model.WebSocketClosed;
import org.openqa.selenium.devtools.v110.network.model.WebSocketCreated;
import org.openqa.selenium.devtools.v110.network.model.WebSocketFrameError;
import org.openqa.selenium.devtools.v110.network.model.WebSocketFrameReceived;
import org.openqa.selenium.devtools.v110.network.model.WebSocketFrameSent;
import org.openqa.selenium.devtools.v110.network.model.WebSocketHandshakeResponseReceived;
import org.openqa.selenium.devtools.v110.network.model.WebSocketWillSendHandshakeRequest;
import org.openqa.selenium.devtools.v110.network.model.WebTransportClosed;
import org.openqa.selenium.devtools.v110.network.model.WebTransportConnectionEstablished;
import org.openqa.selenium.devtools.v110.network.model.WebTransportCreated;
import org.openqa.selenium.devtools.v110.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class Network {
    @Beta
    public static Command<Void> setAcceptedEncodings(List<ContentEncoding> encodings) {
        Objects.requireNonNull(encodings, "encodings is required");
        ImmutableMap.Builder<String, List<ContentEncoding>> params = ImmutableMap.builder();
        params.put("encodings", encodings);
        return new Command<Void>("Network.setAcceptedEncodings", params.build());
    }

    @Beta
    public static Command<Void> clearAcceptedEncodingsOverride() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Network.clearAcceptedEncodingsOverride", params.build());
    }

    @Deprecated
    public static Command<Boolean> canClearBrowserCache() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Boolean>("Network.canClearBrowserCache", params.build(), ConverterFunctions.map("result", Boolean.class));
    }

    @Deprecated
    public static Command<Boolean> canClearBrowserCookies() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Boolean>("Network.canClearBrowserCookies", params.build(), ConverterFunctions.map("result", Boolean.class));
    }

    @Deprecated
    public static Command<Boolean> canEmulateNetworkConditions() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Boolean>("Network.canEmulateNetworkConditions", params.build(), ConverterFunctions.map("result", Boolean.class));
    }

    public static Command<Void> clearBrowserCache() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Network.clearBrowserCache", params.build());
    }

    public static Command<Void> clearBrowserCookies() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Network.clearBrowserCookies", params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> continueInterceptedRequest(InterceptionId interceptionId, Optional<ErrorReason> errorReason, Optional<String> rawResponse, Optional<String> url, Optional<String> method, Optional<String> postData, Optional<Headers> headers, Optional<AuthChallengeResponse> authChallengeResponse) {
        Objects.requireNonNull(interceptionId, "interceptionId is required");
        ImmutableMap.Builder<String, InterceptionId> params = ImmutableMap.builder();
        params.put("interceptionId", interceptionId);
        errorReason.ifPresent(p -> params.put("errorReason", (InterceptionId)p));
        rawResponse.ifPresent(p -> params.put("rawResponse", (InterceptionId)p));
        url.ifPresent(p -> params.put("url", (InterceptionId)p));
        method.ifPresent(p -> params.put("method", (InterceptionId)p));
        postData.ifPresent(p -> params.put("postData", (InterceptionId)p));
        headers.ifPresent(p -> params.put("headers", (InterceptionId)p));
        authChallengeResponse.ifPresent(p -> params.put("authChallengeResponse", (InterceptionId)p));
        return new Command<Void>("Network.continueInterceptedRequest", params.build());
    }

    public static Command<Void> deleteCookies(String name, Optional<String> url, Optional<String> domain, Optional<String> path) {
        Objects.requireNonNull(name, "name is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("name", name);
        url.ifPresent(p -> params.put("url", (String)p));
        domain.ifPresent(p -> params.put("domain", (String)p));
        path.ifPresent(p -> params.put("path", (String)p));
        return new Command<Void>("Network.deleteCookies", params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Network.disable", params.build());
    }

    public static Command<Void> emulateNetworkConditions(Boolean offline, Number latency, Number downloadThroughput, Number uploadThroughput, Optional<ConnectionType> connectionType) {
        Objects.requireNonNull(offline, "offline is required");
        Objects.requireNonNull(latency, "latency is required");
        Objects.requireNonNull(downloadThroughput, "downloadThroughput is required");
        Objects.requireNonNull(uploadThroughput, "uploadThroughput is required");
        ImmutableMap.Builder<String, Serializable> params = ImmutableMap.builder();
        params.put("offline", offline);
        params.put("latency", latency);
        params.put("downloadThroughput", downloadThroughput);
        params.put("uploadThroughput", uploadThroughput);
        connectionType.ifPresent(p -> params.put("connectionType", (Serializable)p));
        return new Command<Void>("Network.emulateNetworkConditions", params.build());
    }

    public static Command<Void> enable(Optional<Integer> maxTotalBufferSize, Optional<Integer> maxResourceBufferSize, Optional<Integer> maxPostDataSize) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        maxTotalBufferSize.ifPresent(p -> params.put("maxTotalBufferSize", p));
        maxResourceBufferSize.ifPresent(p -> params.put("maxResourceBufferSize", p));
        maxPostDataSize.ifPresent(p -> params.put("maxPostDataSize", p));
        return new Command<Void>("Network.enable", params.build());
    }

    public static Command<List<Cookie>> getAllCookies() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<List<Cookie>>("Network.getAllCookies", params.build(), ConverterFunctions.map("cookies", new TypeToken<List<Cookie>>(){}.getType()));
    }

    @Beta
    public static Command<List<String>> getCertificate(String origin) {
        Objects.requireNonNull(origin, "origin is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("origin", origin);
        return new Command<List<String>>("Network.getCertificate", params.build(), ConverterFunctions.map("tableNames", new TypeToken<List<String>>(){}.getType()));
    }

    public static Command<List<Cookie>> getCookies(Optional<List<String>> urls) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        urls.ifPresent(p -> params.put("urls", p));
        return new Command<List<Cookie>>("Network.getCookies", params.build(), ConverterFunctions.map("cookies", new TypeToken<List<Cookie>>(){}.getType()));
    }

    public static Command<GetResponseBodyResponse> getResponseBody(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder<String, RequestId> params = ImmutableMap.builder();
        params.put("requestId", requestId);
        return new Command<GetResponseBodyResponse>("Network.getResponseBody", params.build(), input -> (GetResponseBodyResponse)input.read((Type)((Object)GetResponseBodyResponse.class)));
    }

    public static Command<String> getRequestPostData(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder<String, RequestId> params = ImmutableMap.builder();
        params.put("requestId", requestId);
        return new Command<String>("Network.getRequestPostData", params.build(), ConverterFunctions.map("postData", String.class));
    }

    @Beta
    public static Command<GetResponseBodyForInterceptionResponse> getResponseBodyForInterception(InterceptionId interceptionId) {
        Objects.requireNonNull(interceptionId, "interceptionId is required");
        ImmutableMap.Builder<String, InterceptionId> params = ImmutableMap.builder();
        params.put("interceptionId", interceptionId);
        return new Command<GetResponseBodyForInterceptionResponse>("Network.getResponseBodyForInterception", params.build(), input -> (GetResponseBodyForInterceptionResponse)input.read((Type)((Object)GetResponseBodyForInterceptionResponse.class)));
    }

    @Beta
    public static Command<StreamHandle> takeResponseBodyForInterceptionAsStream(InterceptionId interceptionId) {
        Objects.requireNonNull(interceptionId, "interceptionId is required");
        ImmutableMap.Builder<String, InterceptionId> params = ImmutableMap.builder();
        params.put("interceptionId", interceptionId);
        return new Command<StreamHandle>("Network.takeResponseBodyForInterceptionAsStream", params.build(), ConverterFunctions.map("stream", StreamHandle.class));
    }

    @Beta
    public static Command<Void> replayXHR(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder<String, RequestId> params = ImmutableMap.builder();
        params.put("requestId", requestId);
        return new Command<Void>("Network.replayXHR", params.build());
    }

    @Beta
    public static Command<List<SearchMatch>> searchInResponseBody(RequestId requestId, String query, Optional<Boolean> caseSensitive, Optional<Boolean> isRegex) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(query, "query is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("requestId", requestId);
        params.put("query", query);
        caseSensitive.ifPresent(p -> params.put("caseSensitive", p));
        isRegex.ifPresent(p -> params.put("isRegex", p));
        return new Command<List<SearchMatch>>("Network.searchInResponseBody", params.build(), ConverterFunctions.map("result", new TypeToken<List<SearchMatch>>(){}.getType()));
    }

    @Beta
    public static Command<Void> setBlockedURLs(List<String> urls) {
        Objects.requireNonNull(urls, "urls is required");
        ImmutableMap.Builder<String, List<String>> params = ImmutableMap.builder();
        params.put("urls", urls);
        return new Command<Void>("Network.setBlockedURLs", params.build());
    }

    @Beta
    public static Command<Void> setBypassServiceWorker(Boolean bypass) {
        Objects.requireNonNull(bypass, "bypass is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("bypass", bypass);
        return new Command<Void>("Network.setBypassServiceWorker", params.build());
    }

    public static Command<Void> setCacheDisabled(Boolean cacheDisabled) {
        Objects.requireNonNull(cacheDisabled, "cacheDisabled is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("cacheDisabled", cacheDisabled);
        return new Command<Void>("Network.setCacheDisabled", params.build());
    }

    public static Command<Boolean> setCookie(String name, String value, Optional<String> url, Optional<String> domain, Optional<String> path, Optional<Boolean> secure, Optional<Boolean> httpOnly, Optional<CookieSameSite> sameSite, Optional<TimeSinceEpoch> expires, Optional<CookiePriority> priority, Optional<Boolean> sameParty, Optional<CookieSourceScheme> sourceScheme, Optional<Integer> sourcePort, Optional<String> partitionKey) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("name", name);
        params.put("value", value);
        url.ifPresent(p -> params.put("url", (String)p));
        domain.ifPresent(p -> params.put("domain", (String)p));
        path.ifPresent(p -> params.put("path", (String)p));
        secure.ifPresent(p -> params.put("secure", (String)p));
        httpOnly.ifPresent(p -> params.put("httpOnly", (String)p));
        sameSite.ifPresent(p -> params.put("sameSite", (String)p));
        expires.ifPresent(p -> params.put("expires", (String)p));
        priority.ifPresent(p -> params.put("priority", (String)p));
        sameParty.ifPresent(p -> params.put("sameParty", (String)p));
        sourceScheme.ifPresent(p -> params.put("sourceScheme", (String)p));
        sourcePort.ifPresent(p -> params.put("sourcePort", (String)p));
        partitionKey.ifPresent(p -> params.put("partitionKey", (String)p));
        return new Command<Boolean>("Network.setCookie", params.build(), ConverterFunctions.map("success", Boolean.class));
    }

    public static Command<Void> setCookies(List<CookieParam> cookies) {
        Objects.requireNonNull(cookies, "cookies is required");
        ImmutableMap.Builder<String, List<CookieParam>> params = ImmutableMap.builder();
        params.put("cookies", cookies);
        return new Command<Void>("Network.setCookies", params.build());
    }

    public static Command<Void> setExtraHTTPHeaders(Headers headers) {
        Objects.requireNonNull(headers, "headers is required");
        ImmutableMap.Builder<String, Headers> params = ImmutableMap.builder();
        params.put("headers", headers);
        return new Command<Void>("Network.setExtraHTTPHeaders", params.build());
    }

    @Beta
    public static Command<Void> setAttachDebugStack(Boolean enabled) {
        Objects.requireNonNull(enabled, "enabled is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("enabled", enabled);
        return new Command<Void>("Network.setAttachDebugStack", params.build());
    }

    @Beta
    @Deprecated
    public static Command<Void> setRequestInterception(List<RequestPattern> patterns) {
        Objects.requireNonNull(patterns, "patterns is required");
        ImmutableMap.Builder<String, List<RequestPattern>> params = ImmutableMap.builder();
        params.put("patterns", patterns);
        return new Command<Void>("Network.setRequestInterception", params.build());
    }

    public static Command<Void> setUserAgentOverride(String userAgent, Optional<String> acceptLanguage, Optional<String> platform, Optional<UserAgentMetadata> userAgentMetadata) {
        Objects.requireNonNull(userAgent, "userAgent is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("userAgent", userAgent);
        acceptLanguage.ifPresent(p -> params.put("acceptLanguage", (String)p));
        platform.ifPresent(p -> params.put("platform", (String)p));
        userAgentMetadata.ifPresent(p -> params.put("userAgentMetadata", (String)p));
        return new Command<Void>("Network.setUserAgentOverride", params.build());
    }

    @Beta
    public static Command<SecurityIsolationStatus> getSecurityIsolationStatus(Optional<FrameId> frameId) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        frameId.ifPresent(p -> params.put("frameId", p));
        return new Command<SecurityIsolationStatus>("Network.getSecurityIsolationStatus", params.build(), ConverterFunctions.map("status", SecurityIsolationStatus.class));
    }

    @Beta
    public static Command<Void> enableReportingApi(Boolean enable) {
        Objects.requireNonNull(enable, "enable is required");
        ImmutableMap.Builder<String, Boolean> params = ImmutableMap.builder();
        params.put("enable", enable);
        return new Command<Void>("Network.enableReportingApi", params.build());
    }

    @Beta
    public static Command<LoadNetworkResourcePageResult> loadNetworkResource(Optional<FrameId> frameId, String url, LoadNetworkResourceOptions options) {
        Objects.requireNonNull(url, "url is required");
        Objects.requireNonNull(options, "options is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        frameId.ifPresent(p -> params.put("frameId", p));
        params.put("url", url);
        params.put("options", options);
        return new Command<LoadNetworkResourcePageResult>("Network.loadNetworkResource", params.build(), ConverterFunctions.map("resource", LoadNetworkResourcePageResult.class));
    }

    public static Event<DataReceived> dataReceived() {
        return new Event<DataReceived>("Network.dataReceived", input -> (DataReceived)input.read((Type)((Object)DataReceived.class)));
    }

    public static Event<EventSourceMessageReceived> eventSourceMessageReceived() {
        return new Event<EventSourceMessageReceived>("Network.eventSourceMessageReceived", input -> (EventSourceMessageReceived)input.read((Type)((Object)EventSourceMessageReceived.class)));
    }

    public static Event<LoadingFailed> loadingFailed() {
        return new Event<LoadingFailed>("Network.loadingFailed", input -> (LoadingFailed)input.read((Type)((Object)LoadingFailed.class)));
    }

    public static Event<LoadingFinished> loadingFinished() {
        return new Event<LoadingFinished>("Network.loadingFinished", input -> (LoadingFinished)input.read((Type)((Object)LoadingFinished.class)));
    }

    public static Event<RequestIntercepted> requestIntercepted() {
        return new Event<RequestIntercepted>("Network.requestIntercepted", input -> (RequestIntercepted)input.read((Type)((Object)RequestIntercepted.class)));
    }

    public static Event<RequestId> requestServedFromCache() {
        return new Event<RequestId>("Network.requestServedFromCache", ConverterFunctions.map("requestId", RequestId.class));
    }

    public static Event<RequestWillBeSent> requestWillBeSent() {
        return new Event<RequestWillBeSent>("Network.requestWillBeSent", input -> (RequestWillBeSent)input.read((Type)((Object)RequestWillBeSent.class)));
    }

    public static Event<ResourceChangedPriority> resourceChangedPriority() {
        return new Event<ResourceChangedPriority>("Network.resourceChangedPriority", input -> (ResourceChangedPriority)input.read((Type)((Object)ResourceChangedPriority.class)));
    }

    public static Event<SignedExchangeReceived> signedExchangeReceived() {
        return new Event<SignedExchangeReceived>("Network.signedExchangeReceived", input -> (SignedExchangeReceived)input.read((Type)((Object)SignedExchangeReceived.class)));
    }

    public static Event<ResponseReceived> responseReceived() {
        return new Event<ResponseReceived>("Network.responseReceived", input -> (ResponseReceived)input.read((Type)((Object)ResponseReceived.class)));
    }

    public static Event<WebSocketClosed> webSocketClosed() {
        return new Event<WebSocketClosed>("Network.webSocketClosed", input -> (WebSocketClosed)input.read((Type)((Object)WebSocketClosed.class)));
    }

    public static Event<WebSocketCreated> webSocketCreated() {
        return new Event<WebSocketCreated>("Network.webSocketCreated", input -> (WebSocketCreated)input.read((Type)((Object)WebSocketCreated.class)));
    }

    public static Event<WebSocketFrameError> webSocketFrameError() {
        return new Event<WebSocketFrameError>("Network.webSocketFrameError", input -> (WebSocketFrameError)input.read((Type)((Object)WebSocketFrameError.class)));
    }

    public static Event<WebSocketFrameReceived> webSocketFrameReceived() {
        return new Event<WebSocketFrameReceived>("Network.webSocketFrameReceived", input -> (WebSocketFrameReceived)input.read((Type)((Object)WebSocketFrameReceived.class)));
    }

    public static Event<WebSocketFrameSent> webSocketFrameSent() {
        return new Event<WebSocketFrameSent>("Network.webSocketFrameSent", input -> (WebSocketFrameSent)input.read((Type)((Object)WebSocketFrameSent.class)));
    }

    public static Event<WebSocketHandshakeResponseReceived> webSocketHandshakeResponseReceived() {
        return new Event<WebSocketHandshakeResponseReceived>("Network.webSocketHandshakeResponseReceived", input -> (WebSocketHandshakeResponseReceived)input.read((Type)((Object)WebSocketHandshakeResponseReceived.class)));
    }

    public static Event<WebSocketWillSendHandshakeRequest> webSocketWillSendHandshakeRequest() {
        return new Event<WebSocketWillSendHandshakeRequest>("Network.webSocketWillSendHandshakeRequest", input -> (WebSocketWillSendHandshakeRequest)input.read((Type)((Object)WebSocketWillSendHandshakeRequest.class)));
    }

    public static Event<WebTransportCreated> webTransportCreated() {
        return new Event<WebTransportCreated>("Network.webTransportCreated", input -> (WebTransportCreated)input.read((Type)((Object)WebTransportCreated.class)));
    }

    public static Event<WebTransportConnectionEstablished> webTransportConnectionEstablished() {
        return new Event<WebTransportConnectionEstablished>("Network.webTransportConnectionEstablished", input -> (WebTransportConnectionEstablished)input.read((Type)((Object)WebTransportConnectionEstablished.class)));
    }

    public static Event<WebTransportClosed> webTransportClosed() {
        return new Event<WebTransportClosed>("Network.webTransportClosed", input -> (WebTransportClosed)input.read((Type)((Object)WebTransportClosed.class)));
    }

    public static Event<RequestWillBeSentExtraInfo> requestWillBeSentExtraInfo() {
        return new Event<RequestWillBeSentExtraInfo>("Network.requestWillBeSentExtraInfo", input -> (RequestWillBeSentExtraInfo)input.read((Type)((Object)RequestWillBeSentExtraInfo.class)));
    }

    public static Event<ResponseReceivedExtraInfo> responseReceivedExtraInfo() {
        return new Event<ResponseReceivedExtraInfo>("Network.responseReceivedExtraInfo", input -> (ResponseReceivedExtraInfo)input.read((Type)((Object)ResponseReceivedExtraInfo.class)));
    }

    public static Event<TrustTokenOperationDone> trustTokenOperationDone() {
        return new Event<TrustTokenOperationDone>("Network.trustTokenOperationDone", input -> (TrustTokenOperationDone)input.read((Type)((Object)TrustTokenOperationDone.class)));
    }

    public static Event<SubresourceWebBundleMetadataReceived> subresourceWebBundleMetadataReceived() {
        return new Event<SubresourceWebBundleMetadataReceived>("Network.subresourceWebBundleMetadataReceived", input -> (SubresourceWebBundleMetadataReceived)input.read((Type)((Object)SubresourceWebBundleMetadataReceived.class)));
    }

    public static Event<SubresourceWebBundleMetadataError> subresourceWebBundleMetadataError() {
        return new Event<SubresourceWebBundleMetadataError>("Network.subresourceWebBundleMetadataError", input -> (SubresourceWebBundleMetadataError)input.read((Type)((Object)SubresourceWebBundleMetadataError.class)));
    }

    public static Event<SubresourceWebBundleInnerResponseParsed> subresourceWebBundleInnerResponseParsed() {
        return new Event<SubresourceWebBundleInnerResponseParsed>("Network.subresourceWebBundleInnerResponseParsed", input -> (SubresourceWebBundleInnerResponseParsed)input.read((Type)((Object)SubresourceWebBundleInnerResponseParsed.class)));
    }

    public static Event<SubresourceWebBundleInnerResponseError> subresourceWebBundleInnerResponseError() {
        return new Event<SubresourceWebBundleInnerResponseError>("Network.subresourceWebBundleInnerResponseError", input -> (SubresourceWebBundleInnerResponseError)input.read((Type)((Object)SubresourceWebBundleInnerResponseError.class)));
    }

    public static Event<ReportingApiReport> reportingApiReportAdded() {
        return new Event<ReportingApiReport>("Network.reportingApiReportAdded", ConverterFunctions.map("report", ReportingApiReport.class));
    }

    public static Event<ReportingApiReport> reportingApiReportUpdated() {
        return new Event<ReportingApiReport>("Network.reportingApiReportUpdated", ConverterFunctions.map("report", ReportingApiReport.class));
    }

    public static Event<ReportingApiEndpointsChangedForOrigin> reportingApiEndpointsChangedForOrigin() {
        return new Event<ReportingApiEndpointsChangedForOrigin>("Network.reportingApiEndpointsChangedForOrigin", input -> (ReportingApiEndpointsChangedForOrigin)input.read((Type)((Object)ReportingApiEndpointsChangedForOrigin.class)));
    }

    public static class GetResponseBodyForInterceptionResponse {
        private final String body;
        private final Boolean base64Encoded;

        public GetResponseBodyForInterceptionResponse(String body, Boolean base64Encoded) {
            this.body = Objects.requireNonNull(body, "body is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getBody() {
            return this.body;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResponseBodyForInterceptionResponse fromJson(JsonInput input) {
            String body = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResponseBodyForInterceptionResponse(body, base64Encoded);
        }
    }

    public static class GetResponseBodyResponse {
        private final String body;
        private final Boolean base64Encoded;

        public GetResponseBodyResponse(String body, Boolean base64Encoded) {
            this.body = Objects.requireNonNull(body, "body is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getBody() {
            return this.body;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResponseBodyResponse fromJson(JsonInput input) {
            String body = null;
            Boolean base64Encoded = false;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResponseBodyResponse(body, base64Encoded);
        }
    }
}

