/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v110.target.model;

import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v110.browser.model.BrowserContextID;
import org.openqa.selenium.devtools.v110.page.model.FrameId;
import org.openqa.selenium.devtools.v110.target.model.TargetID;
import org.openqa.selenium.json.JsonInput;

public class TargetInfo {
    private final TargetID targetId;
    private final String type;
    private final String title;
    private final String url;
    private final Boolean attached;
    private final Optional<TargetID> openerId;
    private final Boolean canAccessOpener;
    private final Optional<FrameId> openerFrameId;
    private final Optional<BrowserContextID> browserContextId;
    private final Optional<String> subtype;

    public TargetInfo(TargetID targetId, String type, String title, String url, Boolean attached, Optional<TargetID> openerId, Boolean canAccessOpener, Optional<FrameId> openerFrameId, Optional<BrowserContextID> browserContextId, Optional<String> subtype) {
        this.targetId = Objects.requireNonNull(targetId, "targetId is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.title = Objects.requireNonNull(title, "title is required");
        this.url = Objects.requireNonNull(url, "url is required");
        this.attached = Objects.requireNonNull(attached, "attached is required");
        this.openerId = openerId;
        this.canAccessOpener = Objects.requireNonNull(canAccessOpener, "canAccessOpener is required");
        this.openerFrameId = openerFrameId;
        this.browserContextId = browserContextId;
        this.subtype = subtype;
    }

    public TargetID getTargetId() {
        return this.targetId;
    }

    public String getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public Boolean getAttached() {
        return this.attached;
    }

    public Optional<TargetID> getOpenerId() {
        return this.openerId;
    }

    @Beta
    public Boolean getCanAccessOpener() {
        return this.canAccessOpener;
    }

    @Beta
    public Optional<FrameId> getOpenerFrameId() {
        return this.openerFrameId;
    }

    @Beta
    public Optional<BrowserContextID> getBrowserContextId() {
        return this.browserContextId;
    }

    @Beta
    public Optional<String> getSubtype() {
        return this.subtype;
    }

    private static TargetInfo fromJson(JsonInput input) {
        TargetID targetId = null;
        String type = null;
        String title = null;
        String url = null;
        Boolean attached = false;
        Optional<TargetID> openerId = Optional.empty();
        Boolean canAccessOpener = false;
        Optional<FrameId> openerFrameId = Optional.empty();
        Optional<BrowserContextID> browserContextId = Optional.empty();
        Optional<String> subtype = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "targetId": {
                    targetId = (TargetID)input.read((Type)((Object)TargetID.class));
                    continue block24;
                }
                case "type": {
                    type = input.nextString();
                    continue block24;
                }
                case "title": {
                    title = input.nextString();
                    continue block24;
                }
                case "url": {
                    url = input.nextString();
                    continue block24;
                }
                case "attached": {
                    attached = input.nextBoolean();
                    continue block24;
                }
                case "openerId": {
                    openerId = Optional.ofNullable((TargetID)input.read((Type)((Object)TargetID.class)));
                    continue block24;
                }
                case "canAccessOpener": {
                    canAccessOpener = input.nextBoolean();
                    continue block24;
                }
                case "openerFrameId": {
                    openerFrameId = Optional.ofNullable((FrameId)input.read((Type)((Object)FrameId.class)));
                    continue block24;
                }
                case "browserContextId": {
                    browserContextId = Optional.ofNullable((BrowserContextID)input.read((Type)((Object)BrowserContextID.class)));
                    continue block24;
                }
                case "subtype": {
                    subtype = Optional.ofNullable(input.nextString());
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new TargetInfo(targetId, type, title, url, attached, openerId, canAccessOpener, openerFrameId, browserContextId, subtype);
    }
}

