/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.domdebugger;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.v112.dom.model.NodeId;
import org.openqa.selenium.devtools.v112.domdebugger.model.CSPViolationType;
import org.openqa.selenium.devtools.v112.domdebugger.model.DOMBreakpointType;
import org.openqa.selenium.devtools.v112.domdebugger.model.EventListener;
import org.openqa.selenium.devtools.v112.runtime.model.RemoteObjectId;

public class DOMDebugger {
    public static Command<List<EventListener>> getEventListeners(RemoteObjectId objectId, Optional<Integer> depth, Optional<Boolean> pierce) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder<String, RemoteObjectId> params = ImmutableMap.builder();
        params.put("objectId", objectId);
        depth.ifPresent(p -> params.put("depth", (RemoteObjectId)p));
        pierce.ifPresent(p -> params.put("pierce", (RemoteObjectId)p));
        return new Command<List<EventListener>>("DOMDebugger.getEventListeners", params.build(), ConverterFunctions.map("listeners", new TypeToken<List<EventListener>>(){}.getType()));
    }

    public static Command<Void> removeDOMBreakpoint(NodeId nodeId, DOMBreakpointType type) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(type, "type is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("type", (Object)type);
        return new Command<Void>("DOMDebugger.removeDOMBreakpoint", params.build());
    }

    public static Command<Void> removeEventListenerBreakpoint(String eventName, Optional<String> targetName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("eventName", eventName);
        targetName.ifPresent(p -> params.put("targetName", (String)p));
        return new Command<Void>("DOMDebugger.removeEventListenerBreakpoint", params.build());
    }

    @Beta
    public static Command<Void> removeInstrumentationBreakpoint(String eventName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("eventName", eventName);
        return new Command<Void>("DOMDebugger.removeInstrumentationBreakpoint", params.build());
    }

    public static Command<Void> removeXHRBreakpoint(String url) {
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("url", url);
        return new Command<Void>("DOMDebugger.removeXHRBreakpoint", params.build());
    }

    @Beta
    public static Command<Void> setBreakOnCSPViolation(List<CSPViolationType> violationTypes) {
        Objects.requireNonNull(violationTypes, "violationTypes is required");
        ImmutableMap.Builder<String, List<CSPViolationType>> params = ImmutableMap.builder();
        params.put("violationTypes", violationTypes);
        return new Command<Void>("DOMDebugger.setBreakOnCSPViolation", params.build());
    }

    public static Command<Void> setDOMBreakpoint(NodeId nodeId, DOMBreakpointType type) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(type, "type is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("nodeId", nodeId);
        params.put("type", (Object)type);
        return new Command<Void>("DOMDebugger.setDOMBreakpoint", params.build());
    }

    public static Command<Void> setEventListenerBreakpoint(String eventName, Optional<String> targetName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("eventName", eventName);
        targetName.ifPresent(p -> params.put("targetName", (String)p));
        return new Command<Void>("DOMDebugger.setEventListenerBreakpoint", params.build());
    }

    @Beta
    public static Command<Void> setInstrumentationBreakpoint(String eventName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("eventName", eventName);
        return new Command<Void>("DOMDebugger.setInstrumentationBreakpoint", params.build());
    }

    public static Command<Void> setXHRBreakpoint(String url) {
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
        params.put("url", url);
        return new Command<Void>("DOMDebugger.setXHRBreakpoint", params.build());
    }
}

