/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.domsnapshot.model;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v112.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v112.dom.model.PseudoType;
import org.openqa.selenium.devtools.v112.dom.model.ShadowRootType;
import org.openqa.selenium.devtools.v112.domdebugger.model.EventListener;
import org.openqa.selenium.devtools.v112.domsnapshot.model.NameValue;
import org.openqa.selenium.devtools.v112.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class DOMNode {
    private final Integer nodeType;
    private final String nodeName;
    private final String nodeValue;
    private final Optional<String> textValue;
    private final Optional<String> inputValue;
    private final Optional<Boolean> inputChecked;
    private final Optional<Boolean> optionSelected;
    private final BackendNodeId backendNodeId;
    private final Optional<List<Integer>> childNodeIndexes;
    private final Optional<List<NameValue>> attributes;
    private final Optional<List<Integer>> pseudoElementIndexes;
    private final Optional<Integer> layoutNodeIndex;
    private final Optional<String> documentURL;
    private final Optional<String> baseURL;
    private final Optional<String> contentLanguage;
    private final Optional<String> documentEncoding;
    private final Optional<String> publicId;
    private final Optional<String> systemId;
    private final Optional<FrameId> frameId;
    private final Optional<Integer> contentDocumentIndex;
    private final Optional<PseudoType> pseudoType;
    private final Optional<ShadowRootType> shadowRootType;
    private final Optional<Boolean> isClickable;
    private final Optional<List<EventListener>> eventListeners;
    private final Optional<String> currentSourceURL;
    private final Optional<String> originURL;
    private final Optional<Number> scrollOffsetX;
    private final Optional<Number> scrollOffsetY;

    public DOMNode(Integer nodeType, String nodeName, String nodeValue, Optional<String> textValue, Optional<String> inputValue, Optional<Boolean> inputChecked, Optional<Boolean> optionSelected, BackendNodeId backendNodeId, Optional<List<Integer>> childNodeIndexes, Optional<List<NameValue>> attributes, Optional<List<Integer>> pseudoElementIndexes, Optional<Integer> layoutNodeIndex, Optional<String> documentURL, Optional<String> baseURL, Optional<String> contentLanguage, Optional<String> documentEncoding, Optional<String> publicId, Optional<String> systemId, Optional<FrameId> frameId, Optional<Integer> contentDocumentIndex, Optional<PseudoType> pseudoType, Optional<ShadowRootType> shadowRootType, Optional<Boolean> isClickable, Optional<List<EventListener>> eventListeners, Optional<String> currentSourceURL, Optional<String> originURL, Optional<Number> scrollOffsetX, Optional<Number> scrollOffsetY) {
        this.nodeType = Objects.requireNonNull(nodeType, "nodeType is required");
        this.nodeName = Objects.requireNonNull(nodeName, "nodeName is required");
        this.nodeValue = Objects.requireNonNull(nodeValue, "nodeValue is required");
        this.textValue = textValue;
        this.inputValue = inputValue;
        this.inputChecked = inputChecked;
        this.optionSelected = optionSelected;
        this.backendNodeId = Objects.requireNonNull(backendNodeId, "backendNodeId is required");
        this.childNodeIndexes = childNodeIndexes;
        this.attributes = attributes;
        this.pseudoElementIndexes = pseudoElementIndexes;
        this.layoutNodeIndex = layoutNodeIndex;
        this.documentURL = documentURL;
        this.baseURL = baseURL;
        this.contentLanguage = contentLanguage;
        this.documentEncoding = documentEncoding;
        this.publicId = publicId;
        this.systemId = systemId;
        this.frameId = frameId;
        this.contentDocumentIndex = contentDocumentIndex;
        this.pseudoType = pseudoType;
        this.shadowRootType = shadowRootType;
        this.isClickable = isClickable;
        this.eventListeners = eventListeners;
        this.currentSourceURL = currentSourceURL;
        this.originURL = originURL;
        this.scrollOffsetX = scrollOffsetX;
        this.scrollOffsetY = scrollOffsetY;
    }

    public Integer getNodeType() {
        return this.nodeType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public Optional<String> getTextValue() {
        return this.textValue;
    }

    public Optional<String> getInputValue() {
        return this.inputValue;
    }

    public Optional<Boolean> getInputChecked() {
        return this.inputChecked;
    }

    public Optional<Boolean> getOptionSelected() {
        return this.optionSelected;
    }

    public BackendNodeId getBackendNodeId() {
        return this.backendNodeId;
    }

    public Optional<List<Integer>> getChildNodeIndexes() {
        return this.childNodeIndexes;
    }

    public Optional<List<NameValue>> getAttributes() {
        return this.attributes;
    }

    public Optional<List<Integer>> getPseudoElementIndexes() {
        return this.pseudoElementIndexes;
    }

    public Optional<Integer> getLayoutNodeIndex() {
        return this.layoutNodeIndex;
    }

    public Optional<String> getDocumentURL() {
        return this.documentURL;
    }

    public Optional<String> getBaseURL() {
        return this.baseURL;
    }

    public Optional<String> getContentLanguage() {
        return this.contentLanguage;
    }

    public Optional<String> getDocumentEncoding() {
        return this.documentEncoding;
    }

    public Optional<String> getPublicId() {
        return this.publicId;
    }

    public Optional<String> getSystemId() {
        return this.systemId;
    }

    public Optional<FrameId> getFrameId() {
        return this.frameId;
    }

    public Optional<Integer> getContentDocumentIndex() {
        return this.contentDocumentIndex;
    }

    public Optional<PseudoType> getPseudoType() {
        return this.pseudoType;
    }

    public Optional<ShadowRootType> getShadowRootType() {
        return this.shadowRootType;
    }

    public Optional<Boolean> getIsClickable() {
        return this.isClickable;
    }

    public Optional<List<EventListener>> getEventListeners() {
        return this.eventListeners;
    }

    public Optional<String> getCurrentSourceURL() {
        return this.currentSourceURL;
    }

    public Optional<String> getOriginURL() {
        return this.originURL;
    }

    public Optional<Number> getScrollOffsetX() {
        return this.scrollOffsetX;
    }

    public Optional<Number> getScrollOffsetY() {
        return this.scrollOffsetY;
    }

    private static DOMNode fromJson(JsonInput input) {
        Integer nodeType = 0;
        String nodeName = null;
        String nodeValue = null;
        Optional<String> textValue = Optional.empty();
        Optional<String> inputValue = Optional.empty();
        Optional<Boolean> inputChecked = Optional.empty();
        Optional<Boolean> optionSelected = Optional.empty();
        BackendNodeId backendNodeId = null;
        Optional<List<Integer>> childNodeIndexes = Optional.empty();
        Optional<List<NameValue>> attributes = Optional.empty();
        Optional<List<Integer>> pseudoElementIndexes = Optional.empty();
        Optional<Integer> layoutNodeIndex = Optional.empty();
        Optional<String> documentURL = Optional.empty();
        Optional<String> baseURL = Optional.empty();
        Optional<String> contentLanguage = Optional.empty();
        Optional<String> documentEncoding = Optional.empty();
        Optional<String> publicId = Optional.empty();
        Optional<String> systemId = Optional.empty();
        Optional<FrameId> frameId = Optional.empty();
        Optional<Integer> contentDocumentIndex = Optional.empty();
        Optional<PseudoType> pseudoType = Optional.empty();
        Optional<ShadowRootType> shadowRootType = Optional.empty();
        Optional<Boolean> isClickable = Optional.empty();
        Optional<List<EventListener>> eventListeners = Optional.empty();
        Optional<String> currentSourceURL = Optional.empty();
        Optional<String> originURL = Optional.empty();
        Optional<Number> scrollOffsetX = Optional.empty();
        Optional<Number> scrollOffsetY = Optional.empty();
        input.beginObject();
        block60: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeType": {
                    nodeType = input.nextNumber().intValue();
                    continue block60;
                }
                case "nodeName": {
                    nodeName = input.nextString();
                    continue block60;
                }
                case "nodeValue": {
                    nodeValue = input.nextString();
                    continue block60;
                }
                case "textValue": {
                    textValue = Optional.ofNullable(input.nextString());
                    continue block60;
                }
                case "inputValue": {
                    inputValue = Optional.ofNullable(input.nextString());
                    continue block60;
                }
                case "inputChecked": {
                    inputChecked = Optional.ofNullable(input.nextBoolean());
                    continue block60;
                }
                case "optionSelected": {
                    optionSelected = Optional.ofNullable(input.nextBoolean());
                    continue block60;
                }
                case "backendNodeId": {
                    backendNodeId = (BackendNodeId)input.read((Type)((Object)BackendNodeId.class));
                    continue block60;
                }
                case "childNodeIndexes": {
                    childNodeIndexes = Optional.ofNullable((List)input.read(new TypeToken<List<Integer>>(){}.getType()));
                    continue block60;
                }
                case "attributes": {
                    attributes = Optional.ofNullable((List)input.read(new TypeToken<List<NameValue>>(){}.getType()));
                    continue block60;
                }
                case "pseudoElementIndexes": {
                    pseudoElementIndexes = Optional.ofNullable((List)input.read(new TypeToken<List<Integer>>(){}.getType()));
                    continue block60;
                }
                case "layoutNodeIndex": {
                    layoutNodeIndex = Optional.ofNullable(input.nextNumber().intValue());
                    continue block60;
                }
                case "documentURL": {
                    documentURL = Optional.ofNullable(input.nextString());
                    continue block60;
                }
                case "baseURL": {
                    baseURL = Optional.ofNullable(input.nextString());
                    continue block60;
                }
                case "contentLanguage": {
                    contentLanguage = Optional.ofNullable(input.nextString());
                    continue block60;
                }
                case "documentEncoding": {
                    documentEncoding = Optional.ofNullable(input.nextString());
                    continue block60;
                }
                case "publicId": {
                    publicId = Optional.ofNullable(input.nextString());
                    continue block60;
                }
                case "systemId": {
                    systemId = Optional.ofNullable(input.nextString());
                    continue block60;
                }
                case "frameId": {
                    frameId = Optional.ofNullable((FrameId)input.read((Type)((Object)FrameId.class)));
                    continue block60;
                }
                case "contentDocumentIndex": {
                    contentDocumentIndex = Optional.ofNullable(input.nextNumber().intValue());
                    continue block60;
                }
                case "pseudoType": {
                    pseudoType = Optional.ofNullable((PseudoType)((Object)input.read((Type)((Object)PseudoType.class))));
                    continue block60;
                }
                case "shadowRootType": {
                    shadowRootType = Optional.ofNullable((ShadowRootType)((Object)input.read((Type)((Object)ShadowRootType.class))));
                    continue block60;
                }
                case "isClickable": {
                    isClickable = Optional.ofNullable(input.nextBoolean());
                    continue block60;
                }
                case "eventListeners": {
                    eventListeners = Optional.ofNullable((List)input.read(new TypeToken<List<EventListener>>(){}.getType()));
                    continue block60;
                }
                case "currentSourceURL": {
                    currentSourceURL = Optional.ofNullable(input.nextString());
                    continue block60;
                }
                case "originURL": {
                    originURL = Optional.ofNullable(input.nextString());
                    continue block60;
                }
                case "scrollOffsetX": {
                    scrollOffsetX = Optional.ofNullable(input.nextNumber());
                    continue block60;
                }
                case "scrollOffsetY": {
                    scrollOffsetY = Optional.ofNullable(input.nextNumber());
                    continue block60;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DOMNode(nodeType, nodeName, nodeValue, textValue, inputValue, inputChecked, optionSelected, backendNodeId, childNodeIndexes, attributes, pseudoElementIndexes, layoutNodeIndex, documentURL, baseURL, contentLanguage, documentEncoding, publicId, systemId, frameId, contentDocumentIndex, pseudoType, shadowRootType, isClickable, eventListeners, currentSourceURL, originURL, scrollOffsetX, scrollOffsetY);
    }
}

