/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.io.CountingOutputStream;
import com.google.common.io.FileBackedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.InitialHandshakeResponse;
import org.openqa.selenium.remote.NewSessionPayload;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.W3CHandshakeResponse;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class ProtocolHandshake {
    private static final Logger LOG = Logger.getLogger(ProtocolHandshake.class.getName());

    public Result createSession(HttpHandler client, Command command) throws IOException {
        Set<Capabilities> desired = (Set<Capabilities>)command.getParameters().get("capabilities");
        desired = desired == null || desired.isEmpty() ? Collections.singleton(new ImmutableCapabilities()) : desired;
        try (NewSessionPayload payload = NewSessionPayload.create(desired);){
            Either<SessionNotCreatedException, Result> result = this.createSession(client, payload);
            if (result.isRight()) {
                Result toReturn = result.right();
                LOG.log(Level.FINE, "Detected upstream dialect: {0}", (Object)toReturn.dialect);
                Result result2 = toReturn;
                return result2;
            }
            throw result.left();
        }
    }

    public Either<SessionNotCreatedException, Result> createSession(HttpHandler client, NewSessionPayload payload) throws IOException {
        int threshold = (int)Math.min(Runtime.getRuntime().freeMemory() / 10L, Integer.MAX_VALUE);
        FileBackedOutputStream os = new FileBackedOutputStream(threshold, true);
        try (CountingOutputStream counter = new CountingOutputStream(os);){
            Either<SessionNotCreatedException, Result> either;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)counter, StandardCharsets.UTF_8);){
                payload.writeTo(writer);
                Supplier<InputStream> contentSupplier = () -> {
                    try {
                        return os.asByteSource().openBufferedStream();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                };
                either = this.createSession(client, contentSupplier, counter.getCount());
            }
            return either;
        }
    }

    private Either<SessionNotCreatedException, Result> createSession(HttpHandler client, Supplier<InputStream> contentSupplier, long size) {
        Map blob;
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/session");
        long start = System.currentTimeMillis();
        request.setHeader("Content-Length", String.valueOf(size));
        request.setHeader("Content-Type", "application/json; charset=utf-8");
        request.setContent((Supplier)contentSupplier);
        HttpResponse response = client.execute(request);
        long time = System.currentTimeMillis() - start;
        try {
            blob = (Map)new Json().toType(Contents.string(response), (Type)((Object)Map.class));
        }
        catch (JsonException e) {
            return Either.left(new SessionNotCreatedException("Unable to parse remote response: " + Contents.string(response), e));
        }
        InitialHandshakeResponse initialResponse = new InitialHandshakeResponse(time, response.getStatus(), blob);
        if (initialResponse.getStatusCode() != 200) {
            Object rawResponseValue = initialResponse.getData().get("value");
            String responseMessage = rawResponseValue instanceof Map ? ((Map)rawResponseValue).get("message").toString() : new Json().toJson(rawResponseValue);
            return Either.left(new SessionNotCreatedException(String.format("Response code %s. Message: %s", initialResponse.getStatusCode(), responseMessage)));
        }
        return Stream.of(new W3CHandshakeResponse().getResponseFunction()).map(func -> (Result)func.apply(initialResponse)).filter(Objects::nonNull).findFirst().map(Either::right).orElseGet(() -> Either.left(new SessionNotCreatedException("Handshake response does not match any supported protocol")));
    }

    public static class Result {
        private static final Function<Object, Proxy> massageProxy = obj -> {
            if (obj instanceof Proxy) {
                return (Proxy)obj;
            }
            if (!(obj instanceof Map)) {
                return null;
            }
            Map rawMap = (Map)obj;
            for (Object key : rawMap.keySet()) {
                if (key instanceof String) continue;
                return null;
            }
            return new Proxy((Map)obj);
        };
        private final Dialect dialect;
        private final Map<String, ?> capabilities;
        private final SessionId sessionId;

        Result(Dialect dialect, String sessionId, Map<String, ?> capabilities) {
            this.dialect = dialect;
            this.sessionId = new SessionId(Require.nonNull("Session id", sessionId));
            this.capabilities = capabilities;
            if (capabilities.containsKey("proxy")) {
                capabilities.put("proxy", massageProxy.apply(capabilities.get("proxy")));
            }
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public Response createResponse() {
            Response response = new Response(this.sessionId);
            response.setValue(this.capabilities);
            response.setStatus(0);
            response.setState("success");
            return response;
        }

        public String toString() {
            return String.format("%s: %s", new Object[]{this.dialect, this.capabilities});
        }
    }
}

