/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.AcceptedW3CCapabilityKeys;
import org.openqa.selenium.Alert;
import org.openqa.selenium.Beta;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Pdf;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Point;
import org.openqa.selenium.PrintsPage;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WindowType;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.interactions.Interactive;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.LoggingHandler;
import org.openqa.selenium.logging.Logs;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.print.PrintOptions;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.CommandPayload;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ElementLocation;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.JsonToWebElementConverter;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteLogs;
import org.openqa.selenium.remote.RemoteWebDriverBuilder;
import org.openqa.selenium.remote.RemoteWebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.TracedCommandExecutor;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.remote.UselessFileDetector;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.ConnectionFailedException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.internal.WebElementToJsonConverter;
import org.openqa.selenium.remote.tracing.TracedHttpClient;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryTracer;
import org.openqa.selenium.virtualauthenticator.Credential;
import org.openqa.selenium.virtualauthenticator.HasVirtualAuthenticator;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticator;
import org.openqa.selenium.virtualauthenticator.VirtualAuthenticatorOptions;

@Augmentable
public class RemoteWebDriver
implements WebDriver,
JavascriptExecutor,
HasCapabilities,
HasVirtualAuthenticator,
Interactive,
PrintsPage,
TakesScreenshot {
    private static final Logger logger = Logger.getLogger(RemoteWebDriver.class.getName());
    private final ElementLocation elementLocation = new ElementLocation();
    private Level level = Level.FINE;
    private ErrorHandler errorHandler = new ErrorHandler();
    private CommandExecutor executor;
    private Capabilities capabilities;
    private SessionId sessionId;
    private FileDetector fileDetector = new UselessFileDetector();
    private ExecuteMethod executeMethod;
    private JsonToWebElementConverter converter;
    private Logs remoteLogs;
    private LocalLogs localLogs;

    protected RemoteWebDriver() {
        this.capabilities = this.init(new ImmutableCapabilities());
    }

    public RemoteWebDriver(Capabilities capabilities) {
        this(RemoteWebDriver.getDefaultServerURL(), Require.nonNull("Capabilities", capabilities), true);
    }

    public RemoteWebDriver(Capabilities capabilities, boolean enableTracing) {
        this(RemoteWebDriver.getDefaultServerURL(), Require.nonNull("Capabilities", capabilities), enableTracing);
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities) {
        this(RemoteWebDriver.createExecutor(Require.nonNull("Server URL", remoteAddress), true), Require.nonNull("Capabilities", capabilities));
    }

    public RemoteWebDriver(URL remoteAddress, Capabilities capabilities, boolean enableTracing) {
        this(RemoteWebDriver.createExecutor(Require.nonNull("Server URL", remoteAddress), enableTracing), Require.nonNull("Capabilities", capabilities));
    }

    public RemoteWebDriver(CommandExecutor executor, Capabilities capabilities) {
        this.executor = Require.nonNull("Command executor", executor);
        this.capabilities = this.init(capabilities);
        if (executor instanceof NeedsLocalLogs) {
            ((NeedsLocalLogs)((Object)executor)).setLocalLogs(this.localLogs);
        }
        try {
            this.startSession(capabilities);
        }
        catch (RuntimeException e) {
            try {
                this.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private static URL getDefaultServerURL() {
        try {
            return new URL(System.getProperty("webdriver.remote.server", "http://localhost:4444/"));
        }
        catch (MalformedURLException e) {
            throw new WebDriverException(e);
        }
    }

    private static CommandExecutor createExecutor(URL remoteAddress, boolean enableTracing) {
        ClientConfig config = ClientConfig.defaultConfig().baseUrl(remoteAddress);
        if (enableTracing) {
            OpenTelemetryTracer tracer = OpenTelemetryTracer.getInstance();
            HttpCommandExecutor executor = new HttpCommandExecutor(Collections.emptyMap(), config, (HttpClient.Factory)new TracedHttpClient.Factory(tracer, HttpClient.Factory.createDefault()));
            return new TracedCommandExecutor(executor, tracer);
        }
        return new HttpCommandExecutor(config);
    }

    @Beta
    public static RemoteWebDriverBuilder builder() {
        return new RemoteWebDriverBuilder();
    }

    private Capabilities init(Capabilities capabilities) {
        capabilities = capabilities == null ? new ImmutableCapabilities() : capabilities;
        logger.addHandler(LoggingHandler.getInstance());
        this.converter = new JsonToWebElementConverter(this);
        this.executeMethod = new RemoteExecuteMethod(this);
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        ImmutableCollection logTypesToInclude = builder.build();
        LocalLogs performanceLogger = LocalLogs.getStoringLoggerInstance((Set<String>)((Object)logTypesToInclude));
        LocalLogs clientLogs = LocalLogs.getHandlerBasedLoggerInstance(LoggingHandler.getInstance(), (Set<String>)((Object)logTypesToInclude));
        this.localLogs = LocalLogs.getCombinedLogsHolder(clientLogs, performanceLogger);
        this.remoteLogs = new RemoteLogs(this.executeMethod, this.localLogs);
        return capabilities;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    protected void setSessionId(String opaqueKey) {
        this.sessionId = new SessionId(opaqueKey);
    }

    protected void startSession(Capabilities capabilities) {
        Platform platform;
        this.checkNonW3CCapabilities(capabilities);
        this.checkChromeW3CFalse(capabilities);
        Response response = this.execute(DriverCommand.NEW_SESSION(Collections.singleton(capabilities)));
        if (response == null) {
            throw new SessionNotCreatedException("The underlying command executor returned a null response.");
        }
        Object responseValue = response.getValue();
        if (responseValue == null) {
            throw new SessionNotCreatedException("The underlying command executor returned a response without payload: " + response);
        }
        if (!(responseValue instanceof Map)) {
            throw new SessionNotCreatedException("The underlying command executor returned a response with a non well formed payload: " + response);
        }
        Map rawCapabilities = (Map)responseValue;
        MutableCapabilities returnedCapabilities = new MutableCapabilities(rawCapabilities);
        String platformString = (String)rawCapabilities.get("platformName");
        try {
            platform = platformString == null || "".equals(platformString) ? Platform.ANY : Platform.fromString(platformString);
        }
        catch (WebDriverException e) {
            platform = Platform.extractFromSysProperty(platformString);
        }
        returnedCapabilities.setCapability("platformName", platform);
        this.capabilities = returnedCapabilities;
        this.sessionId = new SessionId(response.getSessionId());
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public CommandExecutor getCommandExecutor() {
        return this.executor;
    }

    protected void setCommandExecutor(CommandExecutor executor) {
        this.executor = executor;
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            return new ImmutableCapabilities();
        }
        return this.capabilities;
    }

    @Override
    public void get(String url) {
        this.execute(DriverCommand.GET(url));
    }

    @Override
    public String getTitle() {
        Response response = this.execute("getTitle");
        Object value = response.getValue();
        return value == null ? "" : value.toString();
    }

    @Override
    public String getCurrentUrl() {
        Response response = this.execute("getCurrentUrl");
        if (response == null || response.getValue() == null) {
            throw new WebDriverException("Remote browser did not respond to getCurrentUrl");
        }
        return response.getValue().toString();
    }

    @Override
    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        Response response = this.execute("screenshot");
        Object result = response.getValue();
        if (result instanceof String) {
            String base64EncodedPng = (String)result;
            return outputType.convertFromBase64Png(base64EncodedPng);
        }
        if (result instanceof byte[]) {
            return outputType.convertFromPngBytes((byte[])result);
        }
        throw new RuntimeException(String.format("Unexpected result for %s command: %s", "screenshot", result == null ? "null" : result.getClass().getName() + " instance"));
    }

    @Override
    public Pdf print(PrintOptions printOptions) throws WebDriverException {
        Response response = this.execute(DriverCommand.PRINT_PAGE(printOptions));
        Object result = response.getValue();
        return new Pdf((String)result);
    }

    @Override
    public WebElement findElement(By locator) {
        Require.nonNull("Locator", locator);
        return this.findElement(this, DriverCommand::FIND_ELEMENT, locator);
    }

    WebElement findElement(SearchContext context, BiFunction<String, Object, CommandPayload> findCommand, By locator) {
        return this.elementLocation.findElement(this, context, findCommand, locator);
    }

    @Override
    public List<WebElement> findElements(By locator) {
        Require.nonNull("Locator", locator);
        return this.findElements(this, DriverCommand::FIND_ELEMENTS, locator);
    }

    public List<WebElement> findElements(SearchContext context, BiFunction<String, Object, CommandPayload> findCommand, By locator) {
        return this.elementLocation.findElements(this, context, findCommand, locator);
    }

    @Deprecated
    protected WebElement findElement(String by, String using) {
        throw new UnsupportedOperationException("`findElement` has been replaced by usages of " + By.Remotable.class);
    }

    @Deprecated
    protected List<WebElement> findElements(String by, String using) {
        throw new UnsupportedOperationException("`findElement` has been replaced by usages of " + By.Remotable.class);
    }

    protected void setFoundBy(SearchContext context, WebElement element, String by, String using) {
        if (element instanceof RemoteWebElement) {
            RemoteWebElement remoteElement = (RemoteWebElement)element;
            remoteElement.setFoundBy(context, by, using);
            remoteElement.setFileDetector(this.getFileDetector());
        }
    }

    @Override
    public String getPageSource() {
        return (String)this.execute("getPageSource").getValue();
    }

    @Override
    public void close() {
        Response response;
        Object value;
        ArrayList windowHandles;
        if (this instanceof HasDevTools) {
            try {
                ((HasDevTools)((Object)this)).maybeGetDevTools().ifPresent(DevTools::disconnectSession);
            }
            catch (ConnectionFailedException unableToEstablishWebsocketConnection) {
                logger.log(Level.SEVERE, "Failed to disconnect DevTools session", unableToEstablishWebsocketConnection);
            }
        }
        if ((windowHandles = (ArrayList)(value = (response = this.execute("close")).getValue())).isEmpty() && this instanceof HasBiDi) {
            ((HasBiDi)((Object)this)).maybeGetBiDi().ifPresent(BiDi::close);
        }
    }

    @Override
    public void quit() {
        if (this.sessionId == null) {
            return;
        }
        try {
            if (this instanceof HasDevTools) {
                ((HasDevTools)((Object)this)).maybeGetDevTools().ifPresent(DevTools::close);
            }
            if (this instanceof HasBiDi) {
                ((HasBiDi)((Object)this)).maybeGetBiDi().ifPresent(BiDi::close);
            }
            this.execute("quit");
        }
        finally {
            this.sessionId = null;
        }
    }

    @Override
    public Set<String> getWindowHandles() {
        Response response = this.execute("getWindowHandles");
        Object value = response.getValue();
        try {
            List returnedValues = (List)value;
            return new LinkedHashSet<String>(returnedValues);
        }
        catch (ClassCastException ex) {
            throw new WebDriverException("Returned value cannot be converted to List<String>: " + value, ex);
        }
    }

    @Override
    public String getWindowHandle() {
        return String.valueOf(this.execute("getCurrentWindowHandle").getValue());
    }

    @Override
    public Object executeScript(String script, Object ... args) {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        List<Object> convertedArgs = Stream.of(args).map(new WebElementToJsonConverter()).collect(Collectors.toList());
        return this.execute(DriverCommand.EXECUTE_SCRIPT(script, convertedArgs)).getValue();
    }

    @Override
    public Object executeAsyncScript(String script, Object ... args) {
        if (!this.isJavascriptEnabled()) {
            throw new UnsupportedOperationException("You must be using an underlying instance of WebDriver that supports executing javascript");
        }
        List<Object> convertedArgs = Stream.of(args).map(new WebElementToJsonConverter()).collect(Collectors.toList());
        return this.execute(DriverCommand.EXECUTE_ASYNC_SCRIPT(script, convertedArgs)).getValue();
    }

    private boolean isJavascriptEnabled() {
        return this.getCapabilities().is("javascriptEnabled");
    }

    @Override
    public WebDriver.TargetLocator switchTo() {
        return new RemoteTargetLocator();
    }

    @Override
    public WebDriver.Navigation navigate() {
        return new RemoteNavigation();
    }

    @Override
    public WebDriver.Options manage() {
        return new RemoteWebDriverOptions();
    }

    protected JsonToWebElementConverter getElementConverter() {
        return this.converter;
    }

    protected void setElementConverter(JsonToWebElementConverter converter) {
        this.converter = Require.nonNull("Element converter", converter);
    }

    public void setLogLevel(Level level) {
        this.level = level;
        logger.setLevel(level);
    }

    protected Response execute(CommandPayload payload) {
        Response response;
        Command command = new Command(this.sessionId, payload);
        long start = System.currentTimeMillis();
        String currentName = Thread.currentThread().getName();
        Thread.currentThread().setName(String.format("Forwarding %s on session %s to remote", command.getName(), this.sessionId));
        try {
            this.log(this.sessionId, command.getName(), command, When.BEFORE);
            response = this.executor.execute(command);
            this.log(this.sessionId, command.getName(), response, When.AFTER);
            if (response == null) {
                Response response2 = null;
                return response2;
            }
            Object value = this.getElementConverter().apply(response.getValue());
            response.setValue(value);
        }
        catch (Throwable e) {
            this.log(this.sessionId, command.getName(), e.getMessage(), When.EXCEPTION);
            WebDriverException toThrow = command.getName().equals("newSession") ? (e instanceof SessionNotCreatedException ? (WebDriverException)e : new SessionNotCreatedException("Possible causes are invalid address of the remote server or browser start-up failure.", e)) : (e instanceof WebDriverException ? (WebDriverException)e : new UnreachableBrowserException("Error communicating with the remote browser. It may have died.", e));
            this.populateWebDriverException(toThrow);
            toThrow.addInfo("Command", command.toString());
            throw toThrow;
        }
        finally {
            Thread.currentThread().setName(currentName);
        }
        try {
            this.errorHandler.throwIfResponseFailed(response, System.currentTimeMillis() - start);
        }
        catch (WebDriverException ex) {
            this.populateWebDriverException(ex);
            ex.addInfo("Command", command.toString());
            throw ex;
        }
        return response;
    }

    private void populateWebDriverException(WebDriverException ex) {
        ex.addInfo("Driver info", this.getClass().getName());
        if (this.getSessionId() != null) {
            ex.addInfo("Session ID", this.getSessionId().toString());
        }
        if (this.getCapabilities() != null) {
            ex.addInfo("Capabilities", this.getCapabilities().toString());
        }
    }

    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        return this.execute(new CommandPayload(driverCommand, parameters));
    }

    protected Response execute(String command) {
        return this.execute(command, ImmutableMap.of());
    }

    protected ExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    @Override
    public void perform(Collection<Sequence> actions) {
        this.execute(DriverCommand.ACTIONS(actions));
    }

    @Override
    public void resetInputState() {
        this.execute("clearActionState");
    }

    @Override
    public VirtualAuthenticator addVirtualAuthenticator(VirtualAuthenticatorOptions options) {
        String authenticatorId = (String)this.execute("addVirtualAuthenticator", options.toMap()).getValue();
        return new RemoteVirtualAuthenticator(authenticatorId);
    }

    @Override
    public void removeVirtualAuthenticator(VirtualAuthenticator authenticator) {
        this.execute("removeVirtualAuthenticator", ImmutableMap.of("authenticatorId", authenticator.getId()));
    }

    protected void log(SessionId sessionId, String commandName, Object toLog, When when) {
        if (!logger.isLoggable(this.level)) {
            return;
        }
        String text = String.valueOf(toLog);
        if ((commandName.equals("executeScript") || commandName.equals("executeAsyncScript")) && text.length() > 100 && Boolean.getBoolean("webdriver.remote.shorten_log_messages")) {
            text = text.substring(0, 100) + "...";
        }
        if ((commandName.equals("screenshot") || commandName.equals("elementScreenshot")) && toLog instanceof Response) {
            Response responseToLog = (Response)toLog;
            Response copyToLog = new Response(new SessionId(responseToLog.getSessionId()));
            copyToLog.setValue("*Screenshot response suppressed*");
            copyToLog.setStatus(responseToLog.getStatus());
            copyToLog.setState(responseToLog.getState());
            text = String.valueOf(copyToLog);
        }
        switch (when) {
            case BEFORE: {
                logger.log(this.level, "Executing: " + commandName + " " + text);
                break;
            }
            case AFTER: {
                logger.log(this.level, "Executed: " + commandName + " " + text);
                break;
            }
            case EXCEPTION: {
                logger.log(this.level, "Exception: " + commandName + " " + text);
                break;
            }
            default: {
                logger.log(this.level, text);
            }
        }
    }

    private void checkNonW3CCapabilities(Capabilities capabilities) {
        List invalid = capabilities.asMap().keySet().stream().filter(key -> !new AcceptedW3CCapabilityKeys().test((String)key)).collect(Collectors.toList());
        if (!invalid.isEmpty()) {
            logger.log(Level.WARNING, () -> String.format("Support for Legacy Capabilities is deprecated; You are sending the following invalid capabilities: %s; Please update to W3C Syntax: https://www.selenium.dev/blog/2022/legacy-protocol-support/", invalid));
        }
    }

    private void checkChromeW3CFalse(Capabilities capabilities) {
        if (Browser.CHROME.is(capabilities) && capabilities.asMap().containsKey("goog:chromeOptions")) {
            Object capability = capabilities.getCapability("goog:chromeOptions");
            boolean w3c = true;
            if (capability instanceof Map) {
                Object rawW3C = ((Map)capability).get("w3c");
                boolean bl = w3c = rawW3C == null || Boolean.parseBoolean(String.valueOf(rawW3C));
            }
            if (!w3c) {
                throw new WebDriverException("Setting 'w3c: false' inside 'goog:chromeOptions' will no longer be supported Please update to W3C Syntax: https://www.selenium.dev/blog/2022/legacy-protocol-support/");
            }
        }
    }

    public FileDetector getFileDetector() {
        return this.fileDetector;
    }

    public void setFileDetector(FileDetector detector) {
        if (detector == null) {
            throw new WebDriverException("You may not set a file detector that is null");
        }
        this.fileDetector = detector;
    }

    public String toString() {
        Capabilities caps = this.getCapabilities();
        if (caps == null) {
            return super.toString();
        }
        Object platformName = caps.getCapability("platformName");
        if (platformName == null) {
            platformName = "unknown";
        }
        return String.format("%s: %s on %s (%s)", this.getClass().getSimpleName(), caps.getBrowserName(), platformName, this.getSessionId());
    }

    private class RemoteVirtualAuthenticator
    implements VirtualAuthenticator {
        private final String id;

        public RemoteVirtualAuthenticator(String id) {
            this.id = Require.nonNull("Id", id);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public void addCredential(Credential credential) {
            RemoteWebDriver.this.execute("addCredential", new ImmutableMap.Builder<String, Object>().putAll(credential.toMap()).put("authenticatorId", this.id).build());
        }

        @Override
        public List<Credential> getCredentials() {
            List response = (List)RemoteWebDriver.this.execute("getCredentials", ImmutableMap.of("authenticatorId", this.id)).getValue();
            return response.stream().map(Credential::fromMap).collect(Collectors.toList());
        }

        @Override
        public void removeCredential(byte[] credentialId) {
            this.removeCredential(Base64.getUrlEncoder().encodeToString(credentialId));
        }

        @Override
        public void removeCredential(String credentialId) {
            RemoteWebDriver.this.execute("removeCredential", ImmutableMap.of("authenticatorId", this.id, "credentialId", credentialId));
        }

        @Override
        public void removeAllCredentials() {
            RemoteWebDriver.this.execute("removeAllCredentials", ImmutableMap.of("authenticatorId", this.id));
        }

        @Override
        public void setUserVerified(boolean verified) {
            RemoteWebDriver.this.execute("setUserVerified", ImmutableMap.of("authenticatorId", this.id, "isUserVerified", verified));
        }
    }

    private class RemoteAlert
    implements Alert {
        @Override
        public void dismiss() {
            RemoteWebDriver.this.execute("dismissAlert");
        }

        @Override
        public void accept() {
            RemoteWebDriver.this.execute("acceptAlert");
        }

        @Override
        public String getText() {
            return (String)RemoteWebDriver.this.execute("getAlertText").getValue();
        }

        @Override
        public void sendKeys(String keysToSend) {
            if (keysToSend == null) {
                throw new IllegalArgumentException("Keys to send should be a not null CharSequence");
            }
            RemoteWebDriver.this.execute(DriverCommand.SET_ALERT_VALUE(keysToSend));
        }
    }

    protected class RemoteTargetLocator
    implements WebDriver.TargetLocator {
        protected RemoteTargetLocator() {
        }

        @Override
        public WebDriver frame(int frameIndex) {
            RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_FRAME(frameIndex));
            return RemoteWebDriver.this;
        }

        @Override
        public WebDriver frame(String frameName) {
            String name = frameName.replaceAll("(['\"\\\\#.:;,!?+<>=~*^$|%&@`{}\\-/\\[\\]\\(\\)])", "\\\\$1");
            List<WebElement> frameElements = RemoteWebDriver.this.findElements(By.cssSelector("frame[name='" + name + "'],iframe[name='" + name + "']"));
            if (frameElements.size() == 0) {
                frameElements = RemoteWebDriver.this.findElements(By.cssSelector("frame#" + name + ",iframe#" + name));
            }
            if (frameElements.size() == 0) {
                throw new NoSuchFrameException("No frame element found by name or id " + frameName);
            }
            return this.frame(frameElements.get(0));
        }

        @Override
        public WebDriver frame(WebElement frameElement) {
            Object elementAsJson = new WebElementToJsonConverter().apply(frameElement);
            RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_FRAME(elementAsJson));
            return RemoteWebDriver.this;
        }

        @Override
        public WebDriver parentFrame() {
            RemoteWebDriver.this.execute("switchToParentFrame");
            return RemoteWebDriver.this;
        }

        @Override
        public WebDriver window(String windowHandleOrName) {
            try {
                RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_WINDOW(windowHandleOrName));
                return RemoteWebDriver.this;
            }
            catch (NoSuchWindowException nsw) {
                String original = RemoteWebDriver.this.getWindowHandle();
                for (String handle : RemoteWebDriver.this.getWindowHandles()) {
                    RemoteWebDriver.this.switchTo().window(handle);
                    if (!windowHandleOrName.equals(RemoteWebDriver.this.executeScript("return window.name", new Object[0]))) continue;
                    return RemoteWebDriver.this;
                }
                RemoteWebDriver.this.switchTo().window(original);
                throw nsw;
            }
        }

        @Override
        public WebDriver newWindow(WindowType typeHint) {
            String original = RemoteWebDriver.this.getWindowHandle();
            try {
                Response response = RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_NEW_WINDOW(typeHint));
                String newWindowHandle = ((Map)response.getValue()).get("handle").toString();
                RemoteWebDriver.this.switchTo().window(newWindowHandle);
                return RemoteWebDriver.this;
            }
            catch (WebDriverException ex) {
                RemoteWebDriver.this.switchTo().window(original);
                throw ex;
            }
        }

        @Override
        public WebDriver defaultContent() {
            RemoteWebDriver.this.execute(DriverCommand.SWITCH_TO_FRAME(null));
            return RemoteWebDriver.this;
        }

        @Override
        public WebElement activeElement() {
            Response response = RemoteWebDriver.this.execute("getActiveElement");
            return (WebElement)response.getValue();
        }

        @Override
        public Alert alert() {
            RemoteWebDriver.this.execute("getAlertText");
            return new RemoteAlert();
        }
    }

    private class RemoteNavigation
    implements WebDriver.Navigation {
        private RemoteNavigation() {
        }

        @Override
        public void back() {
            RemoteWebDriver.this.execute("goBack");
        }

        @Override
        public void forward() {
            RemoteWebDriver.this.execute("goForward");
        }

        @Override
        public void to(String url) {
            RemoteWebDriver.this.get(url);
        }

        @Override
        public void to(URL url) {
            RemoteWebDriver.this.get(String.valueOf(url));
        }

        @Override
        public void refresh() {
            RemoteWebDriver.this.execute("refresh");
        }
    }

    protected class RemoteWebDriverOptions
    implements WebDriver.Options {
        protected RemoteWebDriverOptions() {
        }

        @Override
        @Beta
        public Logs logs() {
            return RemoteWebDriver.this.remoteLogs;
        }

        @Override
        public void addCookie(Cookie cookie) {
            cookie.validate();
            RemoteWebDriver.this.execute(DriverCommand.ADD_COOKIE(cookie));
        }

        @Override
        public void deleteCookieNamed(String name) {
            RemoteWebDriver.this.execute(DriverCommand.DELETE_COOKIE(name));
        }

        @Override
        public void deleteCookie(Cookie cookie) {
            this.deleteCookieNamed(cookie.getName());
        }

        @Override
        public void deleteAllCookies() {
            RemoteWebDriver.this.execute("deleteAllCookies");
        }

        @Override
        public Set<Cookie> getCookies() {
            Object returned = RemoteWebDriver.this.execute("getCookies").getValue();
            HashSet<Cookie> toReturn = new HashSet<Cookie>();
            if (!(returned instanceof Collection)) {
                return toReturn;
            }
            ((Collection)returned).stream().map(o -> (Map)o).map(rawCookie -> {
                Cookie.Builder builder = new Cookie.Builder((String)rawCookie.get("name"), (String)rawCookie.get("value")).path((String)rawCookie.get("path")).domain((String)rawCookie.get("domain")).isSecure(rawCookie.containsKey("secure") && (Boolean)rawCookie.get("secure") != false).isHttpOnly(rawCookie.containsKey("httpOnly") && (Boolean)rawCookie.get("httpOnly") != false).sameSite((String)rawCookie.get("sameSite"));
                Number expiryNum = (Number)rawCookie.get("expiry");
                builder.expiresOn(expiryNum == null ? null : new Date(TimeUnit.SECONDS.toMillis(expiryNum.longValue())));
                return builder.build();
            }).forEach(toReturn::add);
            return toReturn;
        }

        @Override
        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            return null;
        }

        @Override
        public WebDriver.Timeouts timeouts() {
            return new RemoteTimeouts();
        }

        @Override
        @Beta
        public WebDriver.Window window() {
            return new RemoteWindow();
        }

        @Beta
        protected class RemoteWindow
        implements WebDriver.Window {
            Map<String, Object> rawPoint;

            protected RemoteWindow() {
            }

            @Override
            public Dimension getSize() {
                Response response = RemoteWebDriver.this.execute("getCurrentWindowSize");
                Map rawSize = (Map)response.getValue();
                int width = ((Number)rawSize.get("width")).intValue();
                int height = ((Number)rawSize.get("height")).intValue();
                return new Dimension(width, height);
            }

            @Override
            public void setSize(Dimension targetSize) {
                RemoteWebDriver.this.execute(DriverCommand.SET_CURRENT_WINDOW_SIZE(targetSize));
            }

            @Override
            public Point getPosition() {
                Response response = RemoteWebDriver.this.execute(DriverCommand.GET_CURRENT_WINDOW_POSITION());
                this.rawPoint = (Map)response.getValue();
                int x = ((Number)this.rawPoint.get("x")).intValue();
                int y = ((Number)this.rawPoint.get("y")).intValue();
                return new Point(x, y);
            }

            @Override
            public void setPosition(Point targetPosition) {
                RemoteWebDriver.this.execute(DriverCommand.SET_CURRENT_WINDOW_POSITION(targetPosition));
            }

            @Override
            public void maximize() {
                RemoteWebDriver.this.execute("maximizeCurrentWindow");
            }

            @Override
            public void minimize() {
                RemoteWebDriver.this.execute("minimizeCurrentWindow");
            }

            @Override
            public void fullscreen() {
                RemoteWebDriver.this.execute("fullscreenCurrentWindow");
            }
        }

        protected class RemoteTimeouts
        implements WebDriver.Timeouts {
            protected RemoteTimeouts() {
            }

            @Override
            @Deprecated
            public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
                return this.implicitlyWait(Duration.ofMillis(unit.toMillis(time)));
            }

            @Override
            public WebDriver.Timeouts implicitlyWait(Duration duration) {
                RemoteWebDriver.this.execute(DriverCommand.SET_IMPLICIT_WAIT_TIMEOUT(duration));
                return this;
            }

            @Override
            public Duration getImplicitWaitTimeout() {
                Response response = RemoteWebDriver.this.execute("getTimeouts");
                Map rawSize = (Map)response.getValue();
                long timeout = ((Number)rawSize.get("implicit")).longValue();
                return Duration.ofMillis(timeout);
            }

            @Override
            @Deprecated
            public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
                return this.setScriptTimeout(Duration.ofMillis(unit.toMillis(time)));
            }

            @Override
            public WebDriver.Timeouts setScriptTimeout(Duration duration) {
                return this.scriptTimeout(duration);
            }

            @Override
            public WebDriver.Timeouts scriptTimeout(Duration duration) {
                RemoteWebDriver.this.execute(DriverCommand.SET_SCRIPT_TIMEOUT(duration));
                return this;
            }

            @Override
            public Duration getScriptTimeout() {
                Response response = RemoteWebDriver.this.execute("getTimeouts");
                Map rawSize = (Map)response.getValue();
                long timeout = ((Number)rawSize.get("script")).longValue();
                return Duration.ofMillis(timeout);
            }

            @Override
            @Deprecated
            public WebDriver.Timeouts pageLoadTimeout(long time, TimeUnit unit) {
                return this.pageLoadTimeout(Duration.ofMillis(unit.toMillis(time)));
            }

            @Override
            public WebDriver.Timeouts pageLoadTimeout(Duration duration) {
                RemoteWebDriver.this.execute(DriverCommand.SET_PAGE_LOAD_TIMEOUT(duration));
                return this;
            }

            @Override
            public Duration getPageLoadTimeout() {
                Response response = RemoteWebDriver.this.execute("getTimeouts");
                Map rawSize = (Map)response.getValue();
                long timeout = ((Number)rawSize.get("pageLoad")).longValue();
                return Duration.ofMillis(timeout);
            }
        }
    }

    public static enum When {
        BEFORE,
        AFTER,
        EXCEPTION;

    }
}

