/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import com.google.common.collect.ImmutableMap;
import dev.failsafe.Failsafe;
import dev.failsafe.Fallback;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class RetryRequest
implements Filter {
    private static final Logger LOG = Logger.getLogger(RetryRequest.class.getName());
    private static final AtomicReference<HttpResponse> fallBackResponse = new AtomicReference();
    private static final Fallback<Object> fallback = Fallback.of(fallBackResponse::get);
    private static final RetryPolicy<Object> connectionFailurePolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf(failure -> failure.getCause() instanceof ConnectException)).withMaxRetries(3).onRetry(e -> LOG.log(Debug.getDebugLogLevel(), "Connection failure #{0}. Retrying.", e.getAttemptCount())).onRetriesExceeded(e -> fallBackResponse.set((HttpResponse)new HttpResponse().setStatus(408).setContent((Supplier)Contents.asJson(ImmutableMap.of("value", ImmutableMap.of("message", "Connection failure")))))).build();
    private static final RetryPolicy<Object> readTimeoutPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handle((Class<? extends Throwable>)((Class<Throwable>)TimeoutException.class))).withMaxRetries(3).onRetry(e -> LOG.log(Debug.getDebugLogLevel(), "Read timeout #{0}. Retrying.", e.getAttemptCount())).onRetriesExceeded(e -> fallBackResponse.set((HttpResponse)new HttpResponse().setStatus(504).setContent((Supplier)Contents.asJson(ImmutableMap.of("value", ImmutableMap.of("message", "Read timeout")))))).build();
    private static final RetryPolicy<Object> serverErrorPolicy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handleResultIf(response -> ((HttpResponse)response).getStatus() == 500 && Integer.parseInt(((HttpResponse)response).getHeader("Content-Length")) == 0)).handleResultIf(response -> ((HttpResponse)response).getStatus() == 503)).withMaxRetries(2).onRetry(e -> LOG.log(Debug.getDebugLogLevel(), "Failure due to server error #{0}. Retrying.", e.getAttemptCount())).onRetriesExceeded(e -> fallBackResponse.set((HttpResponse)new HttpResponse().setStatus(((HttpResponse)e.getResult()).getStatus()).setContent((Supplier)Contents.asJson(ImmutableMap.of("value", ImmutableMap.of("message", "Internal server error")))))).build();

    @Override
    public HttpHandler apply(HttpHandler next) {
        return req -> Failsafe.with(fallback, (Policy[])new Fallback[0]).compose(serverErrorPolicy).compose(readTimeoutPolicy).compose(connectionFailurePolicy).get(() -> next.execute(req));
    }
}

