/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Predicate;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.AdditionalHttpCommands;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.CommandInfo;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.safari.HasDebugger;

@AutoService(value={AdditionalHttpCommands.class, AugmenterProvider.class})
public class AddHasDebugger
implements AugmenterProvider<HasDebugger>,
AdditionalHttpCommands {
    public static final String ATTACH_DEBUGGER = "attachDebugger";
    private static final Map<String, CommandInfo> COMMANDS = ImmutableMap.of("attachDebugger", new CommandInfo("/session/:sessionId/apple/attach_debugger", HttpMethod.POST));

    @Override
    public Map<String, CommandInfo> getAdditionalCommands() {
        return COMMANDS;
    }

    @Override
    public Predicate<Capabilities> isApplicable() {
        return caps -> "Safari".equals(caps.getBrowserName());
    }

    @Override
    public Class<HasDebugger> getDescribedInterface() {
        return HasDebugger.class;
    }

    @Override
    public HasDebugger getImplementation(Capabilities capabilities, final ExecuteMethod executeMethod) {
        return new HasDebugger(){

            @Override
            public void attachDebugger() {
                executeMethod.execute(AddHasDebugger.ATTACH_DEBUGGER, null);
            }
        };
    }
}

