/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.auto.service.AutoService;
import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.safari.SafariOptions;

public class SafariDriverService
extends DriverService {
    public static final String SAFARI_DRIVER_NAME = "safaridriver";
    public static final String SAFARI_DRIVER_EXE_PROPERTY = "webdriver.safari.driver";
    private static final File SAFARI_DRIVER_EXECUTABLE = new File("/usr/bin/safaridriver");

    @Override
    protected Capabilities getDefaultDriverOptions() {
        return new SafariOptions();
    }

    public SafariDriverService(File executable, int port, List<String> args, Map<String, String> environment2) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment2)));
    }

    public SafariDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment2) throws IOException {
        super(executable, port, timeout, Collections.unmodifiableList(new ArrayList<String>(args)), Collections.unmodifiableMap(new HashMap<String, String>(environment2)));
    }

    @Override
    public String getDriverName() {
        return SAFARI_DRIVER_NAME;
    }

    @Override
    public String getDriverProperty() {
        return SAFARI_DRIVER_EXE_PROPERTY;
    }

    @Override
    public File getDriverExecutable() {
        return SAFARI_DRIVER_EXECUTABLE;
    }

    public static SafariDriverService createDefaultService() {
        return (SafariDriverService)new Builder().build();
    }

    static boolean isPresent() {
        return SafariDriverService.findExePath(SAFARI_DRIVER_EXECUTABLE.getAbsolutePath(), SAFARI_DRIVER_EXE_PROPERTY) != null;
    }

    @Override
    protected void waitUntilAvailable() {
        try {
            PortProber.waitForPortUp(this.getUrl().getPort(), (int)this.getTimeout().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            throw new WebDriverException(e);
        }
    }

    @AutoService(value={DriverService.Builder.class})
    public static class Builder
    extends DriverService.Builder<SafariDriverService, Builder> {
        @Override
        public int score(Capabilities capabilities) {
            int score = 0;
            if (Browser.SAFARI.is(capabilities)) {
                ++score;
            }
            return score;
        }

        @Override
        protected List<String> createArgs() {
            return Arrays.asList("--port", String.valueOf(this.getPort()));
        }

        @Override
        protected SafariDriverService createDriverService(File exe, int port, Duration timeout, List<String> args, Map<String, String> environment2) {
            try {
                return new SafariDriverService(exe, port, timeout, args, environment2);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

