/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.util.Arrays;
import org.springframework.aop.ClassFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class ClassFilters {
    public static ClassFilter union(ClassFilter cf1, ClassFilter cf2) {
        Assert.notNull((Object)cf1, "First ClassFilter must not be null");
        Assert.notNull((Object)cf2, "Second ClassFilter must not be null");
        return new UnionClassFilter(new ClassFilter[]{cf1, cf2});
    }

    public static ClassFilter union(ClassFilter[] classFilters) {
        Assert.notEmpty((Object[])classFilters, "ClassFilter array must not be empty");
        return new UnionClassFilter(classFilters);
    }

    public static ClassFilter intersection(ClassFilter cf1, ClassFilter cf2) {
        Assert.notNull((Object)cf1, "First ClassFilter must not be null");
        Assert.notNull((Object)cf2, "Second ClassFilter must not be null");
        return new IntersectionClassFilter(new ClassFilter[]{cf1, cf2});
    }

    public static ClassFilter intersection(ClassFilter[] classFilters) {
        Assert.notEmpty((Object[])classFilters, "ClassFilter array must not be empty");
        return new IntersectionClassFilter(classFilters);
    }

    private static class UnionClassFilter
    implements ClassFilter,
    Serializable {
        private final ClassFilter[] filters;

        UnionClassFilter(ClassFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean matches(Class<?> clazz) {
            for (ClassFilter filter : this.filters) {
                if (!filter.matches(clazz)) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof UnionClassFilter)) return false;
            UnionClassFilter that = (UnionClassFilter)obj;
            if (!ObjectUtils.nullSafeEquals(this.filters, that.filters)) return false;
            return true;
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.filters);
        }

        public String toString() {
            return this.getClass().getName() + ": " + Arrays.toString(this.filters);
        }
    }

    private static class IntersectionClassFilter
    implements ClassFilter,
    Serializable {
        private final ClassFilter[] filters;

        IntersectionClassFilter(ClassFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean matches(Class<?> clazz) {
            for (ClassFilter filter : this.filters) {
                if (filter.matches(clazz)) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object obj) {
            if (this == obj) return true;
            if (!(obj instanceof IntersectionClassFilter)) return false;
            IntersectionClassFilter that = (IntersectionClassFilter)obj;
            if (!ObjectUtils.nullSafeEquals(this.filters, that.filters)) return false;
            return true;
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.filters);
        }

        public String toString() {
            return this.getClass().getName() + ": " + Arrays.toString(this.filters);
        }
    }
}

