/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import java.util.Arrays;
import org.bson.Document;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.MongoExpression;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BindableMongoExpression
implements MongoExpression {
    private final String expressionString;
    @Nullable
    private final CodecRegistryProvider codecRegistryProvider;
    @Nullable
    private final Object[] args;
    private final Lazy<Document> target;

    public BindableMongoExpression(String expression, @Nullable Object[] args) {
        this(expression, null, args);
    }

    public BindableMongoExpression(String expression, @Nullable CodecRegistryProvider codecRegistryProvider, @Nullable Object[] args) {
        this.expressionString = expression;
        this.codecRegistryProvider = codecRegistryProvider;
        this.args = args;
        this.target = Lazy.of(this::parse);
    }

    public BindableMongoExpression withCodecRegistry(CodecRegistry codecRegistry) {
        return new BindableMongoExpression(this.expressionString, () -> codecRegistry, this.args);
    }

    public BindableMongoExpression bind(Object ... args) {
        return new BindableMongoExpression(this.expressionString, this.codecRegistryProvider, args);
    }

    @Override
    public Document toDocument() {
        return this.target.get();
    }

    public String toString() {
        return "BindableMongoExpression{expressionString='" + this.expressionString + "', args=" + Arrays.toString(this.args) + "}";
    }

    private Document parse() {
        String expression = BindableMongoExpression.wrapJsonIfNecessary(this.expressionString);
        if (ObjectUtils.isEmpty(this.args)) {
            if (this.codecRegistryProvider == null) {
                return Document.parse(expression);
            }
            return Document.parse(expression, this.codecRegistryProvider.getCodecFor(Document.class).orElseGet(() -> new DocumentCodec(this.codecRegistryProvider.getCodecRegistry())));
        }
        ParameterBindingDocumentCodec codec = this.codecRegistryProvider == null ? new ParameterBindingDocumentCodec() : new ParameterBindingDocumentCodec(this.codecRegistryProvider.getCodecRegistry());
        return codec.decode(expression, this.args);
    }

    private static String wrapJsonIfNecessary(String json) {
        if (StringUtils.hasText(json) && json.startsWith("{") && json.endsWith("}")) {
            return json;
        }
        return "{" + json + "}";
    }
}

