/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoException;
import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoResourceHolder;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MongoTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    @Nullable
    private MongoDatabaseFactory dbFactory;
    @Nullable
    private TransactionOptions options;

    public MongoTransactionManager() {
    }

    public MongoTransactionManager(MongoDatabaseFactory dbFactory) {
        this(dbFactory, null);
    }

    public MongoTransactionManager(MongoDatabaseFactory dbFactory, @Nullable TransactionOptions options) {
        Assert.notNull((Object)dbFactory, "DbFactory must not be null");
        this.dbFactory = dbFactory;
        this.options = options;
    }

    @Override
    protected Object doGetTransaction() throws TransactionException {
        MongoResourceHolder resourceHolder = (MongoResourceHolder)TransactionSynchronizationManager.getResource(this.getRequiredDbFactory());
        return new MongoTransactionObject(resourceHolder);
    }

    @Override
    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        return MongoTransactionManager.extractMongoTransaction(transaction).hasResourceHolder();
    }

    @Override
    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        MongoTransactionObject mongoTransactionObject = MongoTransactionManager.extractMongoTransaction(transaction);
        MongoResourceHolder resourceHolder = this.newResourceHolder(definition, ClientSessionOptions.builder().causallyConsistent(true).build());
        mongoTransactionObject.setResourceHolder(resourceHolder);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("About to start transaction for session %s.", MongoTransactionManager.debugString(resourceHolder.getSession())));
        }
        try {
            mongoTransactionObject.startTransaction(this.options);
        }
        catch (MongoException ex) {
            throw new TransactionSystemException(String.format("Could not start Mongo transaction for session %s.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())), ex);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Started transaction for session %s.", MongoTransactionManager.debugString(resourceHolder.getSession())));
        }
        resourceHolder.setSynchronizedWithTransaction(true);
        TransactionSynchronizationManager.bindResource(this.getRequiredDbFactory(), resourceHolder);
    }

    @Override
    protected Object doSuspend(Object transaction) throws TransactionException {
        MongoTransactionObject mongoTransactionObject = MongoTransactionManager.extractMongoTransaction(transaction);
        mongoTransactionObject.setResourceHolder(null);
        return TransactionSynchronizationManager.unbindResource(this.getRequiredDbFactory());
    }

    @Override
    protected void doResume(@Nullable Object transaction, Object suspendedResources) {
        TransactionSynchronizationManager.bindResource(this.getRequiredDbFactory(), suspendedResources);
    }

    @Override
    protected final void doCommit(DefaultTransactionStatus status) throws TransactionException {
        MongoTransactionObject mongoTransactionObject = MongoTransactionManager.extractMongoTransaction(status);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("About to commit transaction for session %s.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())));
        }
        try {
            this.doCommit(mongoTransactionObject);
        }
        catch (Exception ex) {
            throw new TransactionSystemException(String.format("Could not commit Mongo transaction for session %s.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())), ex);
        }
    }

    protected void doCommit(MongoTransactionObject transactionObject) throws Exception {
        transactionObject.commitTransaction();
    }

    @Override
    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        MongoTransactionObject mongoTransactionObject = MongoTransactionManager.extractMongoTransaction(status);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("About to abort transaction for session %s.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())));
        }
        try {
            mongoTransactionObject.abortTransaction();
        }
        catch (MongoException ex) {
            throw new TransactionSystemException(String.format("Could not abort Mongo transaction for session %s.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())), ex);
        }
    }

    @Override
    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        MongoTransactionObject transactionObject = MongoTransactionManager.extractMongoTransaction(status);
        transactionObject.getRequiredResourceHolder().setRollbackOnly();
    }

    @Override
    protected void doCleanupAfterCompletion(Object transaction) {
        Assert.isInstanceOf(MongoTransactionObject.class, transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", MongoTransactionObject.class, transaction.getClass()));
        MongoTransactionObject mongoTransactionObject = (MongoTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource(this.getRequiredDbFactory());
        mongoTransactionObject.getRequiredResourceHolder().clear();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("About to release Session %s after transaction.", MongoTransactionManager.debugString(mongoTransactionObject.getSession())));
        }
        mongoTransactionObject.closeSession();
    }

    public void setDbFactory(MongoDatabaseFactory dbFactory) {
        Assert.notNull((Object)dbFactory, "DbFactory must not be null");
        this.dbFactory = dbFactory;
    }

    public void setOptions(@Nullable TransactionOptions options) {
        this.options = options;
    }

    @Nullable
    public MongoDatabaseFactory getDbFactory() {
        return this.dbFactory;
    }

    @Override
    public MongoDatabaseFactory getResourceFactory() {
        return this.getRequiredDbFactory();
    }

    @Override
    public void afterPropertiesSet() {
        this.getRequiredDbFactory();
    }

    private MongoResourceHolder newResourceHolder(TransactionDefinition definition, ClientSessionOptions options) {
        MongoDatabaseFactory dbFactory = this.getResourceFactory();
        MongoResourceHolder resourceHolder = new MongoResourceHolder(dbFactory.getSession(options), dbFactory);
        resourceHolder.setTimeoutIfNotDefaulted(this.determineTimeout(definition));
        return resourceHolder;
    }

    private MongoDatabaseFactory getRequiredDbFactory() {
        Assert.state(this.dbFactory != null, "MongoTransactionManager operates upon a MongoDbFactory; Did you forget to provide one; It's required");
        return this.dbFactory;
    }

    private static MongoTransactionObject extractMongoTransaction(Object transaction) {
        Assert.isInstanceOf(MongoTransactionObject.class, transaction, () -> String.format("Expected to find a %s but it turned out to be %s.", MongoTransactionObject.class, transaction.getClass()));
        return (MongoTransactionObject)transaction;
    }

    private static MongoTransactionObject extractMongoTransaction(DefaultTransactionStatus status) {
        Assert.isInstanceOf(MongoTransactionObject.class, status.getTransaction(), () -> String.format("Expected to find a %s but it turned out to be %s.", MongoTransactionObject.class, status.getTransaction().getClass()));
        return (MongoTransactionObject)status.getTransaction();
    }

    private static String debugString(@Nullable ClientSession session) {
        if (session == null) {
            return "null";
        }
        Object debugString = String.format("[%s@%s ", ClassUtils.getShortName(session.getClass()), Integer.toHexString(session.hashCode()));
        try {
            if (session.getServerSession() != null) {
                debugString = (String)debugString + String.format("id = %s, ", session.getServerSession().getIdentifier());
                debugString = (String)debugString + String.format("causallyConsistent = %s, ", session.isCausallyConsistent());
                debugString = (String)debugString + String.format("txActive = %s, ", session.hasActiveTransaction());
                debugString = (String)debugString + String.format("txNumber = %d, ", session.getServerSession().getTransactionNumber());
                debugString = (String)debugString + String.format("closed = %b, ", session.getServerSession().isClosed());
                debugString = (String)debugString + String.format("clusterTime = %s", session.getClusterTime());
            } else {
                debugString = (String)debugString + "id = n/a";
                debugString = (String)debugString + String.format("causallyConsistent = %s, ", session.isCausallyConsistent());
                debugString = (String)debugString + String.format("txActive = %s, ", session.hasActiveTransaction());
                debugString = (String)debugString + String.format("clusterTime = %s", session.getClusterTime());
            }
        }
        catch (RuntimeException e) {
            debugString = (String)debugString + String.format("error = %s", e.getMessage());
        }
        debugString = (String)debugString + "]";
        return debugString;
    }

    protected static class MongoTransactionObject
    implements SmartTransactionObject {
        @Nullable
        private MongoResourceHolder resourceHolder;

        MongoTransactionObject(@Nullable MongoResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        void setResourceHolder(@Nullable MongoResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        final boolean hasResourceHolder() {
            return this.resourceHolder != null;
        }

        void startTransaction(@Nullable TransactionOptions options) {
            ClientSession session = this.getRequiredSession();
            if (options != null) {
                session.startTransaction(options);
            } else {
                session.startTransaction();
            }
        }

        public void commitTransaction() {
            this.getRequiredSession().commitTransaction();
        }

        public void abortTransaction() {
            this.getRequiredSession().abortTransaction();
        }

        void closeSession() {
            ClientSession session = this.getRequiredSession();
            if (session.getServerSession() != null && !session.getServerSession().isClosed()) {
                session.close();
            }
        }

        @Nullable
        public ClientSession getSession() {
            return this.resourceHolder != null ? this.resourceHolder.getSession() : null;
        }

        private MongoResourceHolder getRequiredResourceHolder() {
            Assert.state(this.resourceHolder != null, "MongoResourceHolder is required but not present; o_O");
            return this.resourceHolder;
        }

        private ClientSession getRequiredSession() {
            ClientSession session = this.getSession();
            Assert.state(session != null, "A Session is required but it turned out to be null");
            return session;
        }

        @Override
        public boolean isRollbackOnly() {
            return this.resourceHolder != null && this.resourceHolder.isRollbackOnly();
        }

        @Override
        public void flush() {
            TransactionSynchronizationUtils.triggerFlush();
        }
    }
}

