/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.ClientSessionOptions;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoDatabase;
import org.reactivestreams.Publisher;
import org.springframework.data.mongodb.ReactiveMongoDatabaseFactory;
import org.springframework.data.mongodb.ReactiveMongoResourceHolder;
import org.springframework.data.mongodb.SessionSynchronization;
import org.springframework.lang.Nullable;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.reactive.ReactiveResourceSynchronization;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class ReactiveMongoDatabaseUtils {
    public static Mono<Boolean> isTransactionActive(ReactiveMongoDatabaseFactory databaseFactory) {
        if (databaseFactory.isTransactionActive()) {
            return Mono.just((Object)true);
        }
        return TransactionSynchronizationManager.forCurrentTransaction().map(it -> {
            ReactiveMongoResourceHolder holder = (ReactiveMongoResourceHolder)it.getResource(databaseFactory);
            return holder != null && holder.hasActiveTransaction();
        }).onErrorResume(NoTransactionException.class, e -> Mono.just((Object)false));
    }

    public static Mono<MongoDatabase> getDatabase(ReactiveMongoDatabaseFactory factory) {
        return ReactiveMongoDatabaseUtils.doGetMongoDatabase(null, factory, SessionSynchronization.ON_ACTUAL_TRANSACTION);
    }

    public static Mono<MongoDatabase> getDatabase(ReactiveMongoDatabaseFactory factory, SessionSynchronization sessionSynchronization) {
        return ReactiveMongoDatabaseUtils.doGetMongoDatabase(null, factory, sessionSynchronization);
    }

    public static Mono<MongoDatabase> getDatabase(String dbName, ReactiveMongoDatabaseFactory factory) {
        return ReactiveMongoDatabaseUtils.doGetMongoDatabase(dbName, factory, SessionSynchronization.ON_ACTUAL_TRANSACTION);
    }

    public static Mono<MongoDatabase> getDatabase(String dbName, ReactiveMongoDatabaseFactory factory, SessionSynchronization sessionSynchronization) {
        return ReactiveMongoDatabaseUtils.doGetMongoDatabase(dbName, factory, sessionSynchronization);
    }

    private static Mono<MongoDatabase> doGetMongoDatabase(@Nullable String dbName, ReactiveMongoDatabaseFactory factory, SessionSynchronization sessionSynchronization) {
        Assert.notNull((Object)factory, "DatabaseFactory must not be null");
        if (sessionSynchronization == SessionSynchronization.NEVER) {
            return ReactiveMongoDatabaseUtils.getMongoDatabaseOrDefault(dbName, factory);
        }
        return TransactionSynchronizationManager.forCurrentTransaction().filter(TransactionSynchronizationManager::isSynchronizationActive).flatMap(synchronizationManager -> ReactiveMongoDatabaseUtils.doGetSession(synchronizationManager, factory, sessionSynchronization).flatMap(it -> ReactiveMongoDatabaseUtils.getMongoDatabaseOrDefault(dbName, factory.withSession((ClientSession)it)))).onErrorResume(NoTransactionException.class, e -> ReactiveMongoDatabaseUtils.getMongoDatabaseOrDefault(dbName, factory)).switchIfEmpty(ReactiveMongoDatabaseUtils.getMongoDatabaseOrDefault(dbName, factory));
    }

    private static Mono<MongoDatabase> getMongoDatabaseOrDefault(@Nullable String dbName, ReactiveMongoDatabaseFactory factory) {
        return StringUtils.hasText(dbName) ? factory.getMongoDatabase(dbName) : factory.getMongoDatabase();
    }

    private static Mono<ClientSession> doGetSession(TransactionSynchronizationManager synchronizationManager, ReactiveMongoDatabaseFactory dbFactory, SessionSynchronization sessionSynchronization) {
        ReactiveMongoResourceHolder registeredHolder = (ReactiveMongoResourceHolder)synchronizationManager.getResource(dbFactory);
        if (registeredHolder != null && (registeredHolder.hasSession() || registeredHolder.isSynchronizedWithTransaction())) {
            return registeredHolder.hasSession() ? Mono.just((Object)registeredHolder.getSession()) : ReactiveMongoDatabaseUtils.createClientSession(dbFactory).map(registeredHolder::setSessionIfAbsent);
        }
        if (SessionSynchronization.ON_ACTUAL_TRANSACTION.equals((Object)sessionSynchronization)) {
            return Mono.empty();
        }
        return ReactiveMongoDatabaseUtils.createClientSession(dbFactory).map(session -> {
            ReactiveMongoResourceHolder newHolder = new ReactiveMongoResourceHolder((ClientSession)session, dbFactory);
            newHolder.getRequiredSession().startTransaction();
            synchronizationManager.registerSynchronization(new MongoSessionSynchronization(synchronizationManager, newHolder, dbFactory));
            newHolder.setSynchronizedWithTransaction(true);
            synchronizationManager.bindResource(dbFactory, newHolder);
            return newHolder.getSession();
        });
    }

    private static Mono<ClientSession> createClientSession(ReactiveMongoDatabaseFactory dbFactory) {
        return dbFactory.getSession(ClientSessionOptions.builder().causallyConsistent(true).build());
    }

    private static class MongoSessionSynchronization
    extends ReactiveResourceSynchronization<ReactiveMongoResourceHolder, Object> {
        private final ReactiveMongoResourceHolder resourceHolder;

        MongoSessionSynchronization(TransactionSynchronizationManager synchronizationManager, ReactiveMongoResourceHolder resourceHolder, ReactiveMongoDatabaseFactory dbFactory) {
            super(resourceHolder, dbFactory, synchronizationManager);
            this.resourceHolder = resourceHolder;
        }

        @Override
        protected boolean shouldReleaseBeforeCompletion() {
            return false;
        }

        @Override
        protected Mono<Void> processResourceAfterCommit(ReactiveMongoResourceHolder resourceHolder) {
            if (this.isTransactionActive(resourceHolder)) {
                return Mono.from((Publisher)resourceHolder.getRequiredSession().commitTransaction());
            }
            return Mono.empty();
        }

        @Override
        public Mono<Void> afterCompletion(int status) {
            return Mono.defer(() -> {
                if (status == 1 && this.isTransactionActive(this.resourceHolder)) {
                    return Mono.from((Publisher)this.resourceHolder.getRequiredSession().abortTransaction()).then(super.afterCompletion(status));
                }
                return super.afterCompletion(status);
            });
        }

        @Override
        protected Mono<Void> releaseResource(ReactiveMongoResourceHolder resourceHolder, Object resourceKey) {
            return Mono.fromRunnable(() -> {
                if (resourceHolder.hasActiveSession()) {
                    resourceHolder.getRequiredSession().close();
                }
            });
        }

        private boolean isTransactionActive(ReactiveMongoResourceHolder resourceHolder) {
            if (!resourceHolder.hasSession()) {
                return false;
            }
            return resourceHolder.getRequiredSession().hasActiveTransaction();
        }
    }
}

