/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.MongoDriverInformation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.util.Version;
import org.springframework.util.StringUtils;

public class SpringDataMongoDB {
    private static final Log LOGGER = LogFactory.getLog(SpringDataMongoDB.class);
    private static final Version FALLBACK_VERSION = new Version(3);
    private static final MongoDriverInformation DRIVER_INFORMATION = MongoDriverInformation.builder(MongoDriverInformation.builder().build()).driverName("spring-data").build();

    public static MongoDriverInformation driverInformation() {
        return DRIVER_INFORMATION;
    }

    public static Version version() {
        String versionString;
        Package pkg = SpringDataMongoDB.class.getPackage();
        String string = versionString = pkg != null ? pkg.getImplementationVersion() : null;
        if (!StringUtils.hasText(versionString)) {
            LOGGER.debug("Unable to find Spring Data MongoDB version.");
            return FALLBACK_VERSION;
        }
        try {
            return Version.parse(versionString);
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Cannot read Spring Data MongoDB version '%s'.", versionString));
            return FALLBACK_VERSION;
        }
    }
}

