/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.aot;

import java.util.Arrays;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.data.mongodb.aot.MongoAotPredicates;
import org.springframework.data.mongodb.core.mapping.event.AfterConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.AfterSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveAfterConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveAfterSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveBeforeConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveBeforeSaveCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class MongoRuntimeHints
implements RuntimeHintsRegistrar {
    MongoRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        hints.reflection().registerTypes(Arrays.asList(TypeReference.of(BeforeConvertCallback.class), TypeReference.of(BeforeSaveCallback.class), TypeReference.of(AfterConvertCallback.class), TypeReference.of(AfterSaveCallback.class)), builder -> builder.withMembers(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS));
        MongoRuntimeHints.registerTransactionProxyHints(hints, classLoader);
        if (MongoAotPredicates.isReactorPresent()) {
            hints.reflection().registerTypes(Arrays.asList(TypeReference.of(ReactiveBeforeConvertCallback.class), TypeReference.of(ReactiveBeforeSaveCallback.class), TypeReference.of(ReactiveAfterConvertCallback.class), TypeReference.of(ReactiveAfterSaveCallback.class)), builder -> builder.withMembers(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS));
        }
    }

    private static void registerTransactionProxyHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        if (MongoAotPredicates.isSyncClientPresent(classLoader) && ClassUtils.isPresent("org.springframework.aop.SpringProxy", classLoader)) {
            hints.proxies().registerJdkProxy(TypeReference.of("com.mongodb.client.MongoDatabase"), TypeReference.of("org.springframework.aop.SpringProxy"), TypeReference.of("org.springframework.core.DecoratingProxy"));
            hints.proxies().registerJdkProxy(TypeReference.of("com.mongodb.client.MongoCollection"), TypeReference.of("org.springframework.aop.SpringProxy"), TypeReference.of("org.springframework.core.DecoratingProxy"));
        }
    }
}

