/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.config.BeanComponentDefinitionBuilder;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class GridFsTemplateParser
extends AbstractBeanDefinitionParser {
    GridFsTemplateParser() {
    }

    @Override
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText(id) ? id : "gridFsTemplate";
    }

    @Override
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanComponentDefinitionBuilder helper = new BeanComponentDefinitionBuilder(element, parserContext);
        String converterRef = element.getAttribute("converter-ref");
        String dbFactoryRef = element.getAttribute("db-factory-ref");
        String bucket = element.getAttribute("bucket");
        BeanDefinitionBuilder gridFsTemplateBuilder = BeanDefinitionBuilder.genericBeanDefinition(GridFsTemplate.class);
        if (StringUtils.hasText(dbFactoryRef)) {
            gridFsTemplateBuilder.addConstructorArgReference(dbFactoryRef);
        } else {
            gridFsTemplateBuilder.addConstructorArgReference("mongoDbFactory");
        }
        if (StringUtils.hasText(converterRef)) {
            gridFsTemplateBuilder.addConstructorArgReference(converterRef);
        } else {
            gridFsTemplateBuilder.addConstructorArgReference("mappingConverter");
        }
        if (StringUtils.hasText(bucket)) {
            gridFsTemplateBuilder.addConstructorArgValue(bucket);
        }
        return (AbstractBeanDefinition)helper.getComponentIdButFallback(gridFsTemplateBuilder, "gridFsTemplate").getBeanDefinition();
    }
}

