/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.Ordered;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.EnableMongoAuditing;
import org.springframework.data.mongodb.core.mapping.event.AuditingEntityCallback;
import org.springframework.util.Assert;

class MongoAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport
implements Ordered {
    MongoAuditingRegistrar() {
    }

    @Override
    protected Class<? extends Annotation> getAnnotation() {
        return EnableMongoAuditing.class;
    }

    @Override
    protected String getAuditingHandlerBeanName() {
        return "mongoAuditingHandler";
    }

    @Override
    protected void postProcess(BeanDefinitionBuilder builder, AuditingConfiguration configuration, BeanDefinitionRegistry registry) {
        builder.setFactoryMethod("from").addConstructorArgReference("mongoMappingContext");
    }

    @Override
    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, "AuditingConfiguration must not be null");
        return this.configureDefaultAuditHandlerAttributes(configuration, BeanDefinitionBuilder.rootBeanDefinition(IsNewAwareAuditingHandler.class));
    }

    @Override
    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, "BeanDefinition must not be null");
        Assert.notNull((Object)registry, "BeanDefinitionRegistry must not be null");
        BeanDefinitionBuilder listenerBeanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(AuditingEntityCallback.class);
        listenerBeanDefinitionBuilder.addConstructorArgValue(ParsingUtils.getObjectFactoryBeanDefinition(this.getAuditingHandlerBeanName(), registry));
        this.registerInfrastructureBeanWithId(listenerBeanDefinitionBuilder.getBeanDefinition(), AuditingEntityCallback.class.getName(), registry);
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

