/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import java.lang.annotation.Annotation;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.auditing.ReactiveIsNewAwareAuditingHandler;
import org.springframework.data.auditing.config.AuditingBeanDefinitionRegistrarSupport;
import org.springframework.data.auditing.config.AuditingConfiguration;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.EnableReactiveMongoAuditing;
import org.springframework.data.mongodb.core.mapping.event.ReactiveAuditingEntityCallback;
import org.springframework.util.Assert;

class ReactiveMongoAuditingRegistrar
extends AuditingBeanDefinitionRegistrarSupport {
    ReactiveMongoAuditingRegistrar() {
    }

    @Override
    protected Class<? extends Annotation> getAnnotation() {
        return EnableReactiveMongoAuditing.class;
    }

    @Override
    protected String getAuditingHandlerBeanName() {
        return "reactiveMongoAuditingHandler";
    }

    @Override
    protected void postProcess(BeanDefinitionBuilder builder, AuditingConfiguration configuration, BeanDefinitionRegistry registry) {
        builder.setFactoryMethod("from").addConstructorArgReference("mongoMappingContext");
    }

    @Override
    protected BeanDefinitionBuilder getAuditHandlerBeanDefinitionBuilder(AuditingConfiguration configuration) {
        Assert.notNull((Object)configuration, "AuditingConfiguration must not be null");
        return this.configureDefaultAuditHandlerAttributes(configuration, BeanDefinitionBuilder.rootBeanDefinition(ReactiveIsNewAwareAuditingHandler.class));
    }

    @Override
    protected void registerAuditListenerBeanDefinition(BeanDefinition auditingHandlerDefinition, BeanDefinitionRegistry registry) {
        Assert.notNull((Object)auditingHandlerDefinition, "BeanDefinition must not be null");
        Assert.notNull((Object)registry, "BeanDefinitionRegistry must not be null");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ReactiveAuditingEntityCallback.class);
        builder.addConstructorArgValue(ParsingUtils.getObjectFactoryBeanDefinition(this.getAuditingHandlerBeanName(), registry));
        builder.getRawBeanDefinition().setSource(auditingHandlerDefinition.getSource());
        this.registerInfrastructureBeanWithId(builder.getBeanDefinition(), ReactiveAuditingEntityCallback.class.getName(), registry);
    }
}

