/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import com.mongodb.ReadPreference;
import java.beans.PropertyEditorSupport;
import org.springframework.lang.Nullable;

public class ReadPreferencePropertyEditor
extends PropertyEditorSupport {
    @Override
    public void setAsText(@Nullable String readPreferenceString) throws IllegalArgumentException {
        if (readPreferenceString == null) {
            return;
        }
        ReadPreference preference = null;
        try {
            preference = ReadPreference.valueOf(readPreferenceString);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (preference != null) {
            this.setValue(preference);
        } else if ("PRIMARY".equalsIgnoreCase(readPreferenceString)) {
            this.setValue(ReadPreference.primary());
        } else if ("PRIMARY_PREFERRED".equalsIgnoreCase(readPreferenceString)) {
            this.setValue(ReadPreference.primaryPreferred());
        } else if ("SECONDARY".equalsIgnoreCase(readPreferenceString)) {
            this.setValue(ReadPreference.secondary());
        } else if ("SECONDARY_PREFERRED".equalsIgnoreCase(readPreferenceString)) {
            this.setValue(ReadPreference.secondaryPreferred());
        } else if ("NEAREST".equalsIgnoreCase(readPreferenceString)) {
            this.setValue(ReadPreference.nearest());
        } else {
            throw new IllegalArgumentException(String.format("Cannot find matching ReadPreference for %s", readPreferenceString));
        }
    }
}

