/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class ChangeStreamOptions {
    @Nullable
    private Object filter;
    @Nullable
    private BsonValue resumeToken;
    @Nullable
    private FullDocument fullDocumentLookup;
    @Nullable
    private FullDocumentBeforeChange fullDocumentBeforeChangeLookup;
    @Nullable
    private Collation collation;
    @Nullable
    private Object resumeTimestamp;
    private Resume resume = Resume.UNDEFINED;

    protected ChangeStreamOptions() {
    }

    public Optional<Object> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    public Optional<BsonValue> getResumeToken() {
        return Optional.ofNullable(this.resumeToken);
    }

    public Optional<FullDocument> getFullDocumentLookup() {
        return Optional.ofNullable(this.fullDocumentLookup);
    }

    public Optional<FullDocumentBeforeChange> getFullDocumentBeforeChangeLookup() {
        return Optional.ofNullable(this.fullDocumentBeforeChangeLookup);
    }

    public Optional<Collation> getCollation() {
        return Optional.ofNullable(this.collation);
    }

    public Optional<Instant> getResumeTimestamp() {
        return Optional.ofNullable(this.resumeTimestamp).map(timestamp -> ChangeStreamOptions.asTimestampOfType(timestamp, Instant.class));
    }

    public Optional<BsonTimestamp> getResumeBsonTimestamp() {
        return Optional.ofNullable(this.resumeTimestamp).map(timestamp -> ChangeStreamOptions.asTimestampOfType(timestamp, BsonTimestamp.class));
    }

    public boolean isStartAfter() {
        return Resume.START_AFTER.equals((Object)this.resume);
    }

    public boolean isResumeAfter() {
        return Resume.RESUME_AFTER.equals((Object)this.resume);
    }

    public static ChangeStreamOptions empty() {
        return ChangeStreamOptions.builder().build();
    }

    public static ChangeStreamOptionsBuilder builder() {
        return new ChangeStreamOptionsBuilder();
    }

    private static <T> T asTimestampOfType(Object timestamp, Class<T> targetType) {
        return targetType.cast(ChangeStreamOptions.doGetTimestamp(timestamp, targetType));
    }

    private static <T> Object doGetTimestamp(Object timestamp, Class<T> targetType) {
        if (ClassUtils.isAssignableValue(targetType, timestamp)) {
            return timestamp;
        }
        if (timestamp instanceof Instant) {
            return new BsonTimestamp((int)((Instant)timestamp).getEpochSecond(), 0);
        }
        if (timestamp instanceof BsonTimestamp) {
            return Instant.ofEpochSecond(((BsonTimestamp)timestamp).getTime());
        }
        throw new IllegalArgumentException("o_O that should actually not happen; The timestamp should be an Instant or a BsonTimestamp but was " + ObjectUtils.nullSafeClassName(timestamp));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeStreamOptions that = (ChangeStreamOptions)o;
        if (!ObjectUtils.nullSafeEquals(this.filter, that.filter)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.resumeToken, that.resumeToken)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.fullDocumentLookup, (Object)that.fullDocumentLookup)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.fullDocumentBeforeChangeLookup, (Object)that.fullDocumentBeforeChangeLookup)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.collation, that.collation)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.resumeTimestamp, that.resumeTimestamp)) {
            return false;
        }
        return this.resume == that.resume;
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.filter);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.resumeToken);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.fullDocumentLookup);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.fullDocumentBeforeChangeLookup);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.collation);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.resumeTimestamp);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.resume);
        return result;
    }

    static enum Resume {
        UNDEFINED,
        START_AFTER,
        RESUME_AFTER;

    }

    public static class ChangeStreamOptionsBuilder {
        @Nullable
        private Object filter;
        @Nullable
        private BsonValue resumeToken;
        @Nullable
        private FullDocument fullDocumentLookup;
        @Nullable
        private FullDocumentBeforeChange fullDocumentBeforeChangeLookup;
        @Nullable
        private Collation collation;
        @Nullable
        private Object resumeTimestamp;
        private Resume resume = Resume.UNDEFINED;

        private ChangeStreamOptionsBuilder() {
        }

        public ChangeStreamOptionsBuilder collation(Collation collation) {
            Assert.notNull((Object)collation, "Collation must not be null nor empty");
            this.collation = collation;
            return this;
        }

        public ChangeStreamOptionsBuilder filter(Aggregation filter) {
            Assert.notNull((Object)filter, "Filter must not be null");
            this.filter = filter;
            return this;
        }

        public ChangeStreamOptionsBuilder filter(Document ... filter) {
            Assert.noNullElements((Object[])filter, "Filter must not contain null values");
            this.filter = Arrays.asList(filter);
            return this;
        }

        public ChangeStreamOptionsBuilder resumeToken(BsonValue resumeToken) {
            Assert.notNull((Object)resumeToken, "ResumeToken must not be null");
            this.resumeToken = resumeToken;
            if (this.resume == Resume.UNDEFINED) {
                this.resume = Resume.RESUME_AFTER;
            }
            return this;
        }

        public ChangeStreamOptionsBuilder returnFullDocumentOnUpdate() {
            return this.fullDocumentLookup(FullDocument.UPDATE_LOOKUP);
        }

        public ChangeStreamOptionsBuilder fullDocumentLookup(FullDocument lookup) {
            Assert.notNull((Object)lookup, "Lookup must not be null");
            this.fullDocumentLookup = lookup;
            return this;
        }

        public ChangeStreamOptionsBuilder fullDocumentBeforeChangeLookup(FullDocumentBeforeChange lookup) {
            Assert.notNull((Object)lookup, "Lookup must not be null");
            this.fullDocumentBeforeChangeLookup = lookup;
            return this;
        }

        public ChangeStreamOptionsBuilder returnFullDocumentBeforeChange() {
            return this.fullDocumentBeforeChangeLookup(FullDocumentBeforeChange.WHEN_AVAILABLE);
        }

        public ChangeStreamOptionsBuilder resumeAt(Instant resumeTimestamp) {
            Assert.notNull((Object)resumeTimestamp, "ResumeTimestamp must not be null");
            this.resumeTimestamp = resumeTimestamp;
            return this;
        }

        public ChangeStreamOptionsBuilder resumeAt(BsonTimestamp resumeTimestamp) {
            Assert.notNull((Object)resumeTimestamp, "ResumeTimestamp must not be null");
            this.resumeTimestamp = resumeTimestamp;
            return this;
        }

        public ChangeStreamOptionsBuilder resumeAfter(BsonValue resumeToken) {
            this.resumeToken(resumeToken);
            this.resume = Resume.RESUME_AFTER;
            return this;
        }

        public ChangeStreamOptionsBuilder startAfter(BsonValue resumeToken) {
            this.resumeToken(resumeToken);
            this.resume = Resume.START_AFTER;
            return this;
        }

        public ChangeStreamOptions build() {
            ChangeStreamOptions options = new ChangeStreamOptions();
            options.filter = this.filter;
            options.resumeToken = this.resumeToken;
            options.fullDocumentLookup = this.fullDocumentLookup;
            options.fullDocumentBeforeChangeLookup = this.fullDocumentBeforeChangeLookup;
            options.collation = this.collation;
            options.resumeTimestamp = this.resumeTimestamp;
            options.resume = this.resume;
            return options;
        }
    }
}

