/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.query.MetricConversion;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

class CountQuery {
    private final Document source;

    private CountQuery(Document source) {
        this.source = source;
    }

    public static CountQuery of(Document source) {
        return new CountQuery(source);
    }

    public Document toQueryDocument() {
        if (!this.requiresRewrite(this.source)) {
            return this.source;
        }
        Document target = new Document();
        for (Map.Entry<String, Object> entry : this.source.entrySet()) {
            if (entry.getValue() instanceof Document && this.requiresRewrite(entry.getValue())) {
                Document theValue = (Document)entry.getValue();
                target.putAll(CountQuery.createGeoWithin(entry.getKey(), theValue, this.source.get("$and")));
                continue;
            }
            if (entry.getValue() instanceof Collection && this.requiresRewrite(entry.getValue())) {
                Collection source = (Collection)entry.getValue();
                target.put(entry.getKey(), (Object)this.rewriteCollection(source));
                continue;
            }
            if ("$and".equals(entry.getKey()) && target.containsKey("$and")) continue;
            target.put(entry.getKey(), entry.getValue());
        }
        return target;
    }

    private boolean requiresRewrite(Object valueToInspect) {
        if (valueToInspect instanceof Document) {
            return this.requiresRewrite((Document)valueToInspect);
        }
        if (valueToInspect instanceof Collection) {
            return this.requiresRewrite((Collection)valueToInspect);
        }
        return false;
    }

    private boolean requiresRewrite(Collection<?> collection) {
        for (Object o : collection) {
            if (!(o instanceof Document) || !this.requiresRewrite((Document)o)) continue;
            return true;
        }
        return false;
    }

    private boolean requiresRewrite(Document document) {
        if (CountQuery.containsNear(document)) {
            return true;
        }
        for (Object entry : document.values()) {
            if (!this.requiresRewrite(entry)) continue;
            return true;
        }
        return false;
    }

    private Collection<Object> rewriteCollection(Collection<?> source) {
        ArrayList<Object> rewrittenCollection = new ArrayList<Object>(source.size());
        for (Object item : source) {
            if (item instanceof Document && this.requiresRewrite(item)) {
                rewrittenCollection.add(CountQuery.of((Document)item).toQueryDocument());
                continue;
            }
            rewrittenCollection.add(item);
        }
        return rewrittenCollection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Document createGeoWithin(String key, Document source, @Nullable Object $and) {
        ArrayList<Document> criteria;
        boolean spheric = source.containsKey("$nearSphere");
        Object $near = spheric ? source.get("$nearSphere") : source.get("$near");
        Number maxDistance = CountQuery.getMaxDistance(source, $near, spheric);
        List<Object> $centerMax = Arrays.asList(CountQuery.toCenterCoordinates($near), maxDistance);
        Document $geoWithinMax = new Document("$geoWithin", new Document(spheric ? "$centerSphere" : "$center", $centerMax));
        if (!CountQuery.containsNearWithMinDistance(source)) {
            return new Document(key, $geoWithinMax);
        }
        Number minDistance = (Number)source.get("$minDistance");
        List<Object> $centerMin = Arrays.asList(CountQuery.toCenterCoordinates($near), minDistance);
        Document $geoWithinMin = new Document("$geoWithin", new Document(spheric ? "$centerSphere" : "$center", $centerMin));
        if ($and != null) {
            if (!($and instanceof Collection)) throw new IllegalArgumentException("Cannot rewrite query as it contains an '$and' element that is not a Collection: Offending element: " + $and);
            Collection andElements = (Collection)$and;
            criteria = new ArrayList(andElements.size() + 2);
            criteria.addAll(andElements);
        } else {
            criteria = new ArrayList<Document>(2);
        }
        criteria.add(new Document("$nor", Collections.singletonList(new Document(key, $geoWithinMin))));
        criteria.add(new Document(key, $geoWithinMax));
        return new Document("$and", criteria);
    }

    private static Number getMaxDistance(Document source, Object $near, boolean spheric) {
        Document nearDoc;
        Number maxDistance = Double.MAX_VALUE;
        if (source.containsKey("$maxDistance")) {
            return (Number)source.get("$maxDistance");
        }
        if ($near instanceof Document && (nearDoc = (Document)$near).containsKey("$maxDistance")) {
            maxDistance = (Number)nearDoc.get("$maxDistance");
            if (spheric && nearDoc.containsKey("$geometry")) {
                maxDistance = MetricConversion.metersToRadians(maxDistance.doubleValue());
            }
        }
        return maxDistance;
    }

    private static boolean containsNear(Document source) {
        return source.containsKey("$near") || source.containsKey("$nearSphere");
    }

    private static boolean containsNearWithMinDistance(Document source) {
        if (!CountQuery.containsNear(source)) {
            return false;
        }
        return source.containsKey("$minDistance");
    }

    private static Object toCenterCoordinates(Object value) {
        if (ObjectUtils.isArray(value)) {
            return value;
        }
        if (value instanceof Point) {
            return Arrays.asList(((Point)value).getX(), ((Point)value).getY());
        }
        if (value instanceof Document) {
            Document document = (Document)value;
            if (document.containsKey("x")) {
                return Arrays.asList(document.get("x"), document.get("y"));
            }
            if (document.containsKey("$geometry")) {
                Document geoJsonPoint = (Document)((Object)document.get((Object)"$geometry", Document.class));
                return geoJsonPoint.get("coordinates");
            }
        }
        return value;
    }
}

