/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.IndexOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.IndexConverters;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultIndexOperations
implements IndexOperations {
    private static final String PARTIAL_FILTER_EXPRESSION_KEY = "partialFilterExpression";
    private final String collectionName;
    private final QueryMapper mapper;
    @Nullable
    private final Class<?> type;
    private MongoOperations mongoOperations;

    @Deprecated
    public DefaultIndexOperations(MongoDatabaseFactory mongoDbFactory, String collectionName, QueryMapper queryMapper) {
        this(mongoDbFactory, collectionName, queryMapper, null);
    }

    @Deprecated
    public DefaultIndexOperations(MongoDatabaseFactory mongoDbFactory, String collectionName, QueryMapper queryMapper, @Nullable Class<?> type) {
        Assert.notNull((Object)mongoDbFactory, "MongoDbFactory must not be null");
        Assert.notNull((Object)collectionName, "Collection name can not be null");
        Assert.notNull((Object)queryMapper, "QueryMapper must not be null");
        this.collectionName = collectionName;
        this.mapper = queryMapper;
        this.type = type;
        this.mongoOperations = new MongoTemplate(mongoDbFactory);
    }

    public DefaultIndexOperations(MongoOperations mongoOperations, String collectionName, @Nullable Class<?> type) {
        Assert.notNull((Object)mongoOperations, "MongoOperations must not be null");
        Assert.hasText(collectionName, "Collection name must not be null or empty");
        this.mongoOperations = mongoOperations;
        this.mapper = new QueryMapper(mongoOperations.getConverter());
        this.collectionName = collectionName;
        this.type = type;
    }

    @Override
    public String ensureIndex(IndexDefinition indexDefinition) {
        return this.execute(collection -> {
            MongoPersistentEntity<?> entity = this.lookupPersistentEntity(this.type, this.collectionName);
            IndexOptions indexOptions = IndexConverters.indexDefinitionToIndexOptionsConverter().convert(indexDefinition);
            indexOptions = this.addPartialFilterIfPresent(indexOptions, indexDefinition.getIndexOptions(), entity);
            indexOptions = DefaultIndexOperations.addDefaultCollationIfRequired(indexOptions, entity);
            Document mappedKeys = this.mapper.getMappedSort(indexDefinition.getIndexKeys(), entity);
            return collection.createIndex((Bson)mappedKeys, indexOptions);
        });
    }

    @Nullable
    private MongoPersistentEntity<?> lookupPersistentEntity(@Nullable Class<?> entityType, String collection) {
        if (entityType != null) {
            return this.mapper.getMappingContext().getRequiredPersistentEntity((MongoPersistentProperty)((Object)entityType));
        }
        Collection<MongoPersistentEntity<?>> entities = this.mapper.getMappingContext().getPersistentEntities();
        for (MongoPersistentEntity<?> entity : entities) {
            if (!entity.getCollection().equals(collection)) continue;
            return entity;
        }
        return null;
    }

    @Override
    public void dropIndex(String name) {
        this.execute(collection -> {
            collection.dropIndex(name);
            return null;
        });
    }

    @Override
    public void dropAllIndexes() {
        this.dropIndex("*");
    }

    @Override
    public List<IndexInfo> getIndexInfo() {
        return this.execute(new CollectionCallback<List<IndexInfo>>(){

            @Override
            public List<IndexInfo> doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException {
                MongoCursor cursor = collection.listIndexes(Document.class).iterator();
                return this.getIndexData((MongoCursor<Document>)cursor);
            }

            private List<IndexInfo> getIndexData(MongoCursor<Document> cursor) {
                ArrayList<IndexInfo> indexInfoList;
                int available = cursor.available();
                ArrayList<IndexInfo> arrayList = indexInfoList = available > 0 ? new ArrayList<IndexInfo>(available) : new ArrayList();
                while (cursor.hasNext()) {
                    Document ix = (Document)cursor.next();
                    IndexInfo indexInfo = IndexConverters.documentToIndexInfoConverter().convert(ix);
                    indexInfoList.add(indexInfo);
                }
                return indexInfoList;
            }
        });
    }

    @Nullable
    public <T> T execute(CollectionCallback<T> callback) {
        Assert.notNull(callback, "CollectionCallback must not be null");
        if (this.type != null) {
            return this.mongoOperations.execute(this.type, callback);
        }
        return this.mongoOperations.execute(this.collectionName, callback);
    }

    private IndexOptions addPartialFilterIfPresent(IndexOptions ops, Document sourceOptions, @Nullable MongoPersistentEntity<?> entity) {
        if (!sourceOptions.containsKey(PARTIAL_FILTER_EXPRESSION_KEY)) {
            return ops;
        }
        Assert.isInstanceOf(Document.class, sourceOptions.get(PARTIAL_FILTER_EXPRESSION_KEY));
        return ops.partialFilterExpression(this.mapper.getMappedSort((Document)sourceOptions.get(PARTIAL_FILTER_EXPRESSION_KEY), entity));
    }

    private static IndexOptions addDefaultCollationIfRequired(IndexOptions ops, MongoPersistentEntity<?> entity) {
        if (ops.getCollation() != null || entity == null || !entity.hasCollation()) {
            return ops;
        }
        return ops.collation(entity.getCollation().toMongoCollation());
    }
}

