/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import org.bson.Document;
import org.springframework.util.Assert;

class GeoCommandStatistics {
    private static final GeoCommandStatistics NONE = new GeoCommandStatistics(new Document());
    private final Document source;

    private GeoCommandStatistics(Document source) {
        Assert.notNull((Object)source, "Source document must not be null");
        this.source = source;
    }

    public static GeoCommandStatistics from(Document commandResult) {
        Assert.notNull((Object)commandResult, "Command result must not be null");
        Object stats = commandResult.get("stats");
        return stats == null ? NONE : new GeoCommandStatistics((Document)stats);
    }

    public double getAverageDistance() {
        Object averageDistance = this.source.get("avgDistance");
        return averageDistance == null ? Double.NaN : (Double)averageDistance;
    }
}

