/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoClientSettings;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.WriteConcern;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.StreamFactoryFactory;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MongoClientSettingsFactoryBean
extends AbstractFactoryBean<MongoClientSettings> {
    private static final MongoClientSettings DEFAULT_MONGO_SETTINGS = MongoClientSettings.builder().build();
    private CodecRegistry codecRegistry = DEFAULT_MONGO_SETTINGS.getCodecRegistry();
    private StreamFactoryFactory streamFactoryFactory = DEFAULT_MONGO_SETTINGS.getStreamFactoryFactory();
    private ReadPreference readPreference = DEFAULT_MONGO_SETTINGS.getReadPreference();
    private ReadConcern readConcern = DEFAULT_MONGO_SETTINGS.getReadConcern();
    @Nullable
    private Boolean retryReads = null;
    private WriteConcern writeConcern = DEFAULT_MONGO_SETTINGS.getWriteConcern();
    @Nullable
    private Boolean retryWrites = null;
    @Nullable
    private String applicationName = null;
    @Nullable
    private UuidRepresentation uUidRepresentation = null;
    private int socketConnectTimeoutMS = DEFAULT_MONGO_SETTINGS.getSocketSettings().getConnectTimeout(TimeUnit.MILLISECONDS);
    private int socketReadTimeoutMS = DEFAULT_MONGO_SETTINGS.getSocketSettings().getReadTimeout(TimeUnit.MILLISECONDS);
    private int socketReceiveBufferSize = DEFAULT_MONGO_SETTINGS.getSocketSettings().getReceiveBufferSize();
    private int socketSendBufferSize = DEFAULT_MONGO_SETTINGS.getSocketSettings().getSendBufferSize();
    @Nullable
    private String clusterSrvHost = DEFAULT_MONGO_SETTINGS.getClusterSettings().getSrvHost();
    private List<ServerAddress> clusterHosts = Collections.emptyList();
    @Nullable
    private ClusterConnectionMode clusterConnectionMode = null;
    private ClusterType custerRequiredClusterType = DEFAULT_MONGO_SETTINGS.getClusterSettings().getRequiredClusterType();
    private String clusterRequiredReplicaSetName = DEFAULT_MONGO_SETTINGS.getClusterSettings().getRequiredReplicaSetName();
    private long clusterLocalThresholdMS = DEFAULT_MONGO_SETTINGS.getClusterSettings().getLocalThreshold(TimeUnit.MILLISECONDS);
    private long clusterServerSelectionTimeoutMS = DEFAULT_MONGO_SETTINGS.getClusterSettings().getServerSelectionTimeout(TimeUnit.MILLISECONDS);
    private int poolMaxSize = DEFAULT_MONGO_SETTINGS.getConnectionPoolSettings().getMaxSize();
    private int poolMinSize = DEFAULT_MONGO_SETTINGS.getConnectionPoolSettings().getMinSize();
    private long poolMaxWaitTimeMS = DEFAULT_MONGO_SETTINGS.getConnectionPoolSettings().getMaxWaitTime(TimeUnit.MILLISECONDS);
    private long poolMaxConnectionLifeTimeMS = DEFAULT_MONGO_SETTINGS.getConnectionPoolSettings().getMaxConnectionLifeTime(TimeUnit.MILLISECONDS);
    private long poolMaxConnectionIdleTimeMS = DEFAULT_MONGO_SETTINGS.getConnectionPoolSettings().getMaxConnectionIdleTime(TimeUnit.MILLISECONDS);
    private long poolMaintenanceInitialDelayMS = DEFAULT_MONGO_SETTINGS.getConnectionPoolSettings().getMaintenanceInitialDelay(TimeUnit.MILLISECONDS);
    private long poolMaintenanceFrequencyMS = DEFAULT_MONGO_SETTINGS.getConnectionPoolSettings().getMaintenanceFrequency(TimeUnit.MILLISECONDS);
    private boolean sslEnabled = DEFAULT_MONGO_SETTINGS.getSslSettings().isEnabled();
    private boolean sslInvalidHostNameAllowed = DEFAULT_MONGO_SETTINGS.getSslSettings().isInvalidHostNameAllowed();
    private String sslProvider = DEFAULT_MONGO_SETTINGS.getSslSettings().isEnabled() ? DEFAULT_MONGO_SETTINGS.getSslSettings().getContext().getProvider().getName() : "";
    @Nullable
    private AutoEncryptionSettings autoEncryptionSettings;
    @Nullable
    private ServerApi serverApi;
    private long serverHeartbeatFrequencyMS = DEFAULT_MONGO_SETTINGS.getServerSettings().getHeartbeatFrequency(TimeUnit.MILLISECONDS);
    private long serverMinHeartbeatFrequencyMS = DEFAULT_MONGO_SETTINGS.getServerSettings().getMinHeartbeatFrequency(TimeUnit.MILLISECONDS);

    public void setSocketConnectTimeoutMS(int socketConnectTimeoutMS) {
        this.socketConnectTimeoutMS = socketConnectTimeoutMS;
    }

    public void setSocketReadTimeoutMS(int socketReadTimeoutMS) {
        this.socketReadTimeoutMS = socketReadTimeoutMS;
    }

    public void setSocketReceiveBufferSize(int socketReceiveBufferSize) {
        this.socketReceiveBufferSize = socketReceiveBufferSize;
    }

    public void setSocketSendBufferSize(int socketSendBufferSize) {
        this.socketSendBufferSize = socketSendBufferSize;
    }

    public void setServerHeartbeatFrequencyMS(long serverHeartbeatFrequencyMS) {
        this.serverHeartbeatFrequencyMS = serverHeartbeatFrequencyMS;
    }

    public void setServerMinHeartbeatFrequencyMS(long serverMinHeartbeatFrequencyMS) {
        this.serverMinHeartbeatFrequencyMS = serverMinHeartbeatFrequencyMS;
    }

    public void setClusterSrvHost(String clusterSrvHost) {
        this.clusterSrvHost = clusterSrvHost;
    }

    public void setClusterHosts(ServerAddress[] clusterHosts) {
        this.clusterHosts = Arrays.asList(clusterHosts);
    }

    public void setClusterConnectionMode(ClusterConnectionMode clusterConnectionMode) {
        this.clusterConnectionMode = clusterConnectionMode;
    }

    public void setCusterRequiredClusterType(ClusterType custerRequiredClusterType) {
        this.custerRequiredClusterType = custerRequiredClusterType;
    }

    public void setClusterRequiredReplicaSetName(String clusterRequiredReplicaSetName) {
        this.clusterRequiredReplicaSetName = clusterRequiredReplicaSetName;
    }

    public void setClusterLocalThresholdMS(long clusterLocalThresholdMS) {
        this.clusterLocalThresholdMS = clusterLocalThresholdMS;
    }

    public void setClusterServerSelectionTimeoutMS(long clusterServerSelectionTimeoutMS) {
        this.clusterServerSelectionTimeoutMS = clusterServerSelectionTimeoutMS;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }

    public void setPoolMinSize(int poolMinSize) {
        this.poolMinSize = poolMinSize;
    }

    public void setPoolMaxWaitTimeMS(long poolMaxWaitTimeMS) {
        this.poolMaxWaitTimeMS = poolMaxWaitTimeMS;
    }

    public void setPoolMaxConnectionLifeTimeMS(long poolMaxConnectionLifeTimeMS) {
        this.poolMaxConnectionLifeTimeMS = poolMaxConnectionLifeTimeMS;
    }

    public void setPoolMaxConnectionIdleTimeMS(long poolMaxConnectionIdleTimeMS) {
        this.poolMaxConnectionIdleTimeMS = poolMaxConnectionIdleTimeMS;
    }

    public void setPoolMaintenanceInitialDelayMS(long poolMaintenanceInitialDelayMS) {
        this.poolMaintenanceInitialDelayMS = poolMaintenanceInitialDelayMS;
    }

    public void setPoolMaintenanceFrequencyMS(long poolMaintenanceFrequencyMS) {
        this.poolMaintenanceFrequencyMS = poolMaintenanceFrequencyMS;
    }

    public void setSslEnabled(Boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void setSslInvalidHostNameAllowed(Boolean sslInvalidHostNameAllowed) {
        this.sslInvalidHostNameAllowed = sslInvalidHostNameAllowed;
    }

    public void setSslProvider(String sslProvider) {
        this.sslProvider = sslProvider;
    }

    public void setApplicationName(@Nullable String applicationName) {
        this.applicationName = applicationName;
    }

    public void setRetryReads(@Nullable Boolean retryReads) {
        this.retryReads = retryReads;
    }

    public void setReadConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    public void setRetryWrites(@Nullable Boolean retryWrites) {
        this.retryWrites = retryWrites;
    }

    public void setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public void setStreamFactoryFactory(StreamFactoryFactory streamFactoryFactory) {
        this.streamFactoryFactory = streamFactoryFactory;
    }

    public void setCodecRegistry(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    public void setuUidRepresentation(@Nullable UuidRepresentation uUidRepresentation) {
        this.uUidRepresentation = uUidRepresentation;
    }

    public void setAutoEncryptionSettings(@Nullable AutoEncryptionSettings autoEncryptionSettings) {
        this.autoEncryptionSettings = autoEncryptionSettings;
    }

    public void setServerApi(@Nullable ServerApi serverApi) {
        this.serverApi = serverApi;
    }

    @Override
    public Class<?> getObjectType() {
        return MongoClientSettings.class;
    }

    @Override
    protected MongoClientSettings createInstance() {
        MongoClientSettings.Builder builder = MongoClientSettings.builder().readPreference(this.readPreference).writeConcern(this.writeConcern).readConcern(this.readConcern).codecRegistry(this.codecRegistry).applicationName(this.applicationName).autoEncryptionSettings(this.autoEncryptionSettings).applyToClusterSettings(settings -> {
            settings.serverSelectionTimeout(this.clusterServerSelectionTimeoutMS, TimeUnit.MILLISECONDS);
            if (this.clusterConnectionMode != null) {
                settings.mode(this.clusterConnectionMode);
            }
            settings.requiredReplicaSetName(this.clusterRequiredReplicaSetName);
            if (!CollectionUtils.isEmpty(this.clusterHosts)) {
                settings.hosts(this.clusterHosts);
            }
            settings.localThreshold(this.clusterLocalThresholdMS, TimeUnit.MILLISECONDS);
            settings.requiredClusterType(this.custerRequiredClusterType);
            if (StringUtils.hasText(this.clusterSrvHost)) {
                settings.srvHost(this.clusterSrvHost);
            }
        }).applyToConnectionPoolSettings(settings -> {
            settings.minSize(this.poolMinSize);
            settings.maxSize(this.poolMaxSize);
            settings.maxConnectionIdleTime(this.poolMaxConnectionIdleTimeMS, TimeUnit.MILLISECONDS);
            settings.maxWaitTime(this.poolMaxWaitTimeMS, TimeUnit.MILLISECONDS);
            settings.maxConnectionLifeTime(this.poolMaxConnectionLifeTimeMS, TimeUnit.MILLISECONDS);
            settings.maintenanceFrequency(this.poolMaintenanceFrequencyMS, TimeUnit.MILLISECONDS);
            settings.maintenanceInitialDelay(this.poolMaintenanceInitialDelayMS, TimeUnit.MILLISECONDS);
        }).applyToServerSettings(settings -> {
            settings.minHeartbeatFrequency(this.serverMinHeartbeatFrequencyMS, TimeUnit.MILLISECONDS);
            settings.heartbeatFrequency(this.serverHeartbeatFrequencyMS, TimeUnit.MILLISECONDS);
        }).applyToSocketSettings(settings -> {
            settings.connectTimeout(this.socketConnectTimeoutMS, TimeUnit.MILLISECONDS);
            settings.readTimeout(this.socketReadTimeoutMS, TimeUnit.MILLISECONDS);
            settings.receiveBufferSize(this.socketReceiveBufferSize);
            settings.sendBufferSize(this.socketSendBufferSize);
        }).applyToSslSettings(settings -> {
            settings.enabled(this.sslEnabled);
            if (this.sslEnabled) {
                settings.invalidHostNameAllowed(this.sslInvalidHostNameAllowed);
                try {
                    settings.context(StringUtils.hasText(this.sslProvider) ? SSLContext.getInstance(this.sslProvider) : SSLContext.getDefault());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        });
        if (this.streamFactoryFactory != null) {
            builder = builder.streamFactoryFactory(this.streamFactoryFactory);
        }
        if (this.retryReads != null) {
            builder = builder.retryReads(this.retryReads);
        }
        if (this.retryWrites != null) {
            builder = builder.retryWrites(this.retryWrites);
        }
        if (this.uUidRepresentation != null) {
            builder = builder.uuidRepresentation(this.uUidRepresentation);
        }
        if (this.serverApi != null) {
            builder = builder.serverApi(this.serverApi);
        }
        return builder.build();
    }
}

