/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.WriteConcernResult;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.mongodb.core.MongoActionOperation;
import org.springframework.util.Assert;

public class MongoDataIntegrityViolationException
extends DataIntegrityViolationException {
    private static final long serialVersionUID = -186980521176764046L;
    private final WriteConcernResult writeResult;
    private final MongoActionOperation actionOperation;

    public MongoDataIntegrityViolationException(String message, WriteConcernResult writeResult, MongoActionOperation actionOperation) {
        super(message);
        Assert.notNull((Object)writeResult, "WriteResult must not be null");
        Assert.notNull((Object)actionOperation, "MongoActionOperation must not be null");
        this.writeResult = writeResult;
        this.actionOperation = actionOperation;
    }

    public WriteConcernResult getWriteResult() {
        return this.writeResult;
    }

    public MongoActionOperation getActionOperation() {
        return this.actionOperation;
    }
}

