/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import org.bson.Document;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.PersistentPropertyTranslator;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.util.Predicates;

class PropertyOperations {
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    PropertyOperations(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    Document computeMappedFieldsForProjection(EntityProjection<?, ?> projection, Document fields) {
        if (!projection.isClosedProjection()) {
            return fields;
        }
        Document projectedFields = new Document();
        if (projection.getMappedType().getType().isInterface()) {
            projection.forEach(it -> projectedFields.put(it.getPropertyPath().getSegment(), (Object)1));
        } else {
            PersistentPropertyTranslator translator = PersistentPropertyTranslator.create(this.mappingContext.getRequiredPersistentEntity((MongoPersistentProperty)((Object)projection.getDomainType())), Predicates.negate(MongoPersistentProperty::hasExplicitFieldName));
            MongoPersistentEntity<?> persistentEntity = this.mappingContext.getRequiredPersistentEntity((MongoPersistentProperty)((Object)projection.getMappedType()));
            for (MongoPersistentProperty property : persistentEntity) {
                projectedFields.put(translator.translate(property).getFieldName(), (Object)1);
            }
        }
        return projectedFields;
    }
}

