/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AccumulatorOperators;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ConvertOperators;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.SetWindowFieldsOperation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ArithmeticOperators {
    public static ArithmeticOperatorFactory valueOf(String fieldReference) {
        return new ArithmeticOperatorFactory(fieldReference);
    }

    public static ArithmeticOperatorFactory valueOf(AggregationExpression expression) {
        return new ArithmeticOperatorFactory(expression);
    }

    public static Rand rand() {
        return new Rand();
    }

    public static class ArithmeticOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public ArithmeticOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public ArithmeticOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            this.fieldReference = null;
            this.expression = expression;
        }

        public Abs abs() {
            return this.usesFieldRef() ? Abs.absoluteValueOf(this.fieldReference) : Abs.absoluteValueOf(this.expression);
        }

        public Add add(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return this.createAdd().add(fieldReference);
        }

        public Add add(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return this.createAdd().add(expression);
        }

        public Add add(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return this.createAdd().add(value);
        }

        private Add createAdd() {
            return this.usesFieldRef() ? Add.valueOf(this.fieldReference) : Add.valueOf(this.expression);
        }

        public Ceil ceil() {
            return this.usesFieldRef() ? Ceil.ceilValueOf(this.fieldReference) : Ceil.ceilValueOf(this.expression);
        }

        public Derivative derivative() {
            return this.derivative((String)null);
        }

        public Derivative derivative(SetWindowFieldsOperation.WindowUnit unit) {
            Assert.notNull((Object)unit, "Window unit must not be null");
            return this.derivative(unit.name().toLowerCase(Locale.ROOT));
        }

        public Derivative derivative(@Nullable String unit) {
            Derivative derivative = this.usesFieldRef() ? Derivative.derivativeOf(this.fieldReference) : Derivative.derivativeOf(this.expression);
            return StringUtils.hasText(unit) ? derivative.unit(unit) : derivative;
        }

        public Divide divideBy(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return this.createDivide().divideBy(fieldReference);
        }

        public Divide divideBy(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return this.createDivide().divideBy(expression);
        }

        public Divide divideBy(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return this.createDivide().divideBy(value);
        }

        private Divide createDivide() {
            return this.usesFieldRef() ? Divide.valueOf(this.fieldReference) : Divide.valueOf(this.expression);
        }

        public Exp exp() {
            return this.usesFieldRef() ? Exp.expValueOf(this.fieldReference) : Exp.expValueOf(this.expression);
        }

        public Floor floor() {
            return this.usesFieldRef() ? Floor.floorValueOf(this.fieldReference) : Floor.floorValueOf(this.expression);
        }

        public Integral integral() {
            return this.usesFieldRef() ? Integral.integralOf(this.fieldReference) : Integral.integralOf(this.expression);
        }

        public Integral integral(SetWindowFieldsOperation.WindowUnit unit) {
            Assert.notNull((Object)unit, "Window unit must not be null");
            return this.integral(unit.name().toLowerCase(Locale.ROOT));
        }

        public Integral integral(String unit) {
            Assert.hasText(unit, "Unit must not be empty");
            return this.integral().unit(unit);
        }

        public Ln ln() {
            return this.usesFieldRef() ? Ln.lnValueOf(this.fieldReference) : Ln.lnValueOf(this.expression);
        }

        public Log log(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return this.createLog().log(fieldReference);
        }

        public Log log(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return this.createLog().log(this.fieldReference);
        }

        public Log log(Number base) {
            Assert.notNull((Object)base, "Base must not be null");
            return this.createLog().log(base);
        }

        private Log createLog() {
            return this.usesFieldRef() ? Log.valueOf(this.fieldReference) : Log.valueOf(this.expression);
        }

        public Log10 log10() {
            return this.usesFieldRef() ? Log10.log10ValueOf(this.fieldReference) : Log10.log10ValueOf(this.expression);
        }

        public Mod mod(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return this.createMod().mod(fieldReference);
        }

        public Mod mod(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return this.createMod().mod(expression);
        }

        public Mod mod(Number value) {
            Assert.notNull((Object)value, "Base must not be null");
            return this.createMod().mod(value);
        }

        private Mod createMod() {
            return this.usesFieldRef() ? Mod.valueOf(this.fieldReference) : Mod.valueOf(this.expression);
        }

        public Multiply multiplyBy(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return this.createMultiply().multiplyBy(fieldReference);
        }

        public Multiply multiplyBy(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return this.createMultiply().multiplyBy(expression);
        }

        public Multiply multiplyBy(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return this.createMultiply().multiplyBy(value);
        }

        private Multiply createMultiply() {
            return this.usesFieldRef() ? Multiply.valueOf(this.fieldReference) : Multiply.valueOf(this.expression);
        }

        public Pow pow(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return this.createPow().pow(fieldReference);
        }

        public Pow pow(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return this.createPow().pow(expression);
        }

        public Pow pow(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return this.createPow().pow(value);
        }

        private Pow createPow() {
            return this.usesFieldRef() ? Pow.valueOf(this.fieldReference) : Pow.valueOf(this.expression);
        }

        public Sqrt sqrt() {
            return this.usesFieldRef() ? Sqrt.sqrtOf(this.fieldReference) : Sqrt.sqrtOf(this.expression);
        }

        public Subtract subtract(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return this.createSubtract().subtract(fieldReference);
        }

        public Subtract subtract(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return this.createSubtract().subtract(expression);
        }

        public Subtract subtract(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return this.createSubtract().subtract(value);
        }

        private Subtract createSubtract() {
            return this.usesFieldRef() ? Subtract.valueOf(this.fieldReference) : Subtract.valueOf(this.expression);
        }

        public Trunc trunc() {
            return this.usesFieldRef() ? Trunc.truncValueOf(this.fieldReference) : Trunc.truncValueOf(this.expression);
        }

        public AccumulatorOperators.Sum sum() {
            return this.usesFieldRef() ? AccumulatorOperators.Sum.sumOf(this.fieldReference) : AccumulatorOperators.Sum.sumOf(this.expression);
        }

        public AccumulatorOperators.Avg avg() {
            return this.usesFieldRef() ? AccumulatorOperators.Avg.avgOf(this.fieldReference) : AccumulatorOperators.Avg.avgOf(this.expression);
        }

        public AccumulatorOperators.Max max() {
            return this.usesFieldRef() ? AccumulatorOperators.Max.maxOf(this.fieldReference) : AccumulatorOperators.Max.maxOf(this.expression);
        }

        public AccumulatorOperators.Min min() {
            return this.usesFieldRef() ? AccumulatorOperators.Min.minOf(this.fieldReference) : AccumulatorOperators.Min.minOf(this.expression);
        }

        public AccumulatorOperators.StdDevPop stdDevPop() {
            return this.usesFieldRef() ? AccumulatorOperators.StdDevPop.stdDevPopOf(this.fieldReference) : AccumulatorOperators.StdDevPop.stdDevPopOf(this.expression);
        }

        public AccumulatorOperators.StdDevSamp stdDevSamp() {
            return this.usesFieldRef() ? AccumulatorOperators.StdDevSamp.stdDevSampOf(this.fieldReference) : AccumulatorOperators.StdDevSamp.stdDevSampOf(this.expression);
        }

        public AccumulatorOperators.CovariancePop covariancePop(String fieldReference) {
            return this.covariancePop().and(fieldReference);
        }

        public AccumulatorOperators.CovariancePop covariancePop(AggregationExpression expression) {
            return this.covariancePop().and(expression);
        }

        private AccumulatorOperators.CovariancePop covariancePop() {
            return this.usesFieldRef() ? AccumulatorOperators.CovariancePop.covariancePopOf(this.fieldReference) : AccumulatorOperators.CovariancePop.covariancePopOf(this.expression);
        }

        public AccumulatorOperators.CovarianceSamp covarianceSamp(String fieldReference) {
            return this.covarianceSamp().and(fieldReference);
        }

        public AccumulatorOperators.CovarianceSamp covarianceSamp(AggregationExpression expression) {
            return this.covarianceSamp().and(expression);
        }

        private AccumulatorOperators.CovarianceSamp covarianceSamp() {
            return this.usesFieldRef() ? AccumulatorOperators.CovarianceSamp.covarianceSampOf(this.fieldReference) : AccumulatorOperators.CovarianceSamp.covarianceSampOf(this.expression);
        }

        public Round round() {
            return this.usesFieldRef() ? Round.roundValueOf(this.fieldReference) : Round.roundValueOf(this.expression);
        }

        public Round roundToPlace(int place) {
            return this.round().place(place);
        }

        public Sin sin() {
            return this.sin(AngularUnit.RADIANS);
        }

        public Sin sin(AngularUnit unit) {
            return this.usesFieldRef() ? Sin.sinOf(this.fieldReference, unit) : Sin.sinOf(this.expression, unit);
        }

        public Sinh sinh() {
            return this.sinh(AngularUnit.RADIANS);
        }

        public Sinh sinh(AngularUnit unit) {
            return this.usesFieldRef() ? Sinh.sinhOf(this.fieldReference, unit) : Sinh.sinhOf(this.expression, unit);
        }

        public ASin asin() {
            return this.usesFieldRef() ? ASin.asinOf(this.fieldReference) : ASin.asinOf(this.expression);
        }

        public ASinh asinh() {
            return this.usesFieldRef() ? ASinh.asinhOf(this.fieldReference) : ASinh.asinhOf(this.expression);
        }

        public Cos cos() {
            return this.cos(AngularUnit.RADIANS);
        }

        public Cos cos(AngularUnit unit) {
            return this.usesFieldRef() ? Cos.cosOf(this.fieldReference, unit) : Cos.cosOf(this.expression, unit);
        }

        public Cosh cosh() {
            return this.cosh(AngularUnit.RADIANS);
        }

        public Cosh cosh(AngularUnit unit) {
            return this.usesFieldRef() ? Cosh.coshOf(this.fieldReference, unit) : Cosh.coshOf(this.expression, unit);
        }

        public ACos acos() {
            return this.usesFieldRef() ? ACos.acosOf(this.fieldReference) : ACos.acosOf(this.expression);
        }

        public ACosh acosh() {
            return this.usesFieldRef() ? ACosh.acoshOf(this.fieldReference) : ACosh.acoshOf(this.expression);
        }

        public Tan tan() {
            return this.tan(AngularUnit.RADIANS);
        }

        public ATan atan() {
            return this.usesFieldRef() ? ATan.atanOf(this.fieldReference) : ATan.atanOf(this.expression);
        }

        public ATan2 atan2(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return this.createATan2().atan2of(value);
        }

        public ATan2 atan2(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return this.createATan2().atan2of(fieldReference);
        }

        public ATan2 atan2(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return this.createATan2().atan2of(expression);
        }

        private ATan2 createATan2() {
            return this.usesFieldRef() ? ATan2.valueOf(this.fieldReference) : ATan2.valueOf(this.expression);
        }

        public ATanh atanh() {
            return this.usesFieldRef() ? ATanh.atanhOf(this.fieldReference) : ATanh.atanhOf(this.expression);
        }

        public Tan tan(AngularUnit unit) {
            return this.usesFieldRef() ? Tan.tanOf(this.fieldReference, unit) : Tan.tanOf(this.expression, unit);
        }

        public Tanh tanh() {
            return this.tanh(AngularUnit.RADIANS);
        }

        public Tanh tanh(AngularUnit unit) {
            return this.usesFieldRef() ? Tanh.tanhOf(this.fieldReference, unit) : Tanh.tanhOf(this.expression, unit);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }

    public static class Rand
    implements AggregationExpression {
        @Override
        public Document toDocument(AggregationOperationContext context) {
            return new Document("$rand", new Document());
        }
    }

    public static class ATanh
    extends AbstractAggregationExpression {
        private ATanh(Object value) {
            super(value);
        }

        public static ATanh atanhOf(String fieldReference) {
            return new ATanh(Fields.field(fieldReference));
        }

        public static ATanh atanhOf(AggregationExpression expression) {
            return new ATanh(expression);
        }

        public static ATanh atanhOf(Object value) {
            return new ATanh(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$atanh";
        }
    }

    public static class Tanh
    extends AbstractAggregationExpression {
        private Tanh(Object value) {
            super(value);
        }

        public static Tanh tanhOf(String fieldReference) {
            return Tanh.tanhOf(fieldReference, AngularUnit.RADIANS);
        }

        public static Tanh tanhOf(String fieldReference, AngularUnit unit) {
            return Tanh.tanh(Fields.field(fieldReference), unit);
        }

        public static Tanh tanhOf(AggregationExpression expression) {
            return Tanh.tanhOf(expression, AngularUnit.RADIANS);
        }

        public static Tanh tanhOf(AggregationExpression expression, AngularUnit unit) {
            return Tanh.tanh(expression, unit);
        }

        public static Tanh tanh(Object value) {
            return Tanh.tanh(value, AngularUnit.RADIANS);
        }

        public static Tanh tanh(Object value, AngularUnit unit) {
            if (ObjectUtils.nullSafeEquals((Object)AngularUnit.DEGREES, (Object)unit)) {
                return new Tanh(ConvertOperators.DegreesToRadians.degreesToRadians(value));
            }
            return new Tanh(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$tanh";
        }
    }

    public static class ATan2
    extends AbstractAggregationExpression {
        private ATan2(List<?> value) {
            super(value);
        }

        public static ATan2 valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new ATan2(ATan2.asFields(fieldReference));
        }

        public static ATan2 valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new ATan2(Collections.singletonList(expression));
        }

        public ATan2 atan2of(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new ATan2(this.append(Fields.field(fieldReference)));
        }

        public ATan2 atan2of(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new ATan2(this.append(expression));
        }

        public ATan2 atan2of(Number value) {
            return new ATan2(this.append(value));
        }

        @Override
        protected String getMongoMethod() {
            return "$atan2";
        }
    }

    public static class ATan
    extends AbstractAggregationExpression {
        private ATan(Object value) {
            super(value);
        }

        public static ATan atanOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new ATan(Fields.field(fieldReference));
        }

        public static ATan atanOf(AggregationExpression expression) {
            return new ATan(expression);
        }

        public static ATan atanOf(Number value) {
            return new ATan(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$atan";
        }
    }

    public static class Tan
    extends AbstractAggregationExpression {
        private Tan(Object value) {
            super(value);
        }

        public static Tan tanOf(String fieldReference) {
            return Tan.tanOf(fieldReference, AngularUnit.RADIANS);
        }

        public static Tan tanOf(String fieldReference, AngularUnit unit) {
            return Tan.tan(Fields.field(fieldReference), unit);
        }

        public static Tan tanOf(AggregationExpression expression) {
            return Tan.tanOf(expression, AngularUnit.RADIANS);
        }

        public static Tan tanOf(AggregationExpression expression, AngularUnit unit) {
            return Tan.tan(expression, unit);
        }

        public static Tan tan(Object value) {
            return Tan.tan(value, AngularUnit.RADIANS);
        }

        public static Tan tan(Object value, AngularUnit unit) {
            if (ObjectUtils.nullSafeEquals((Object)AngularUnit.DEGREES, (Object)unit)) {
                return new Tan(ConvertOperators.DegreesToRadians.degreesToRadians(value));
            }
            return new Tan(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$tan";
        }
    }

    public static class ACosh
    extends AbstractAggregationExpression {
        private ACosh(Object value) {
            super(value);
        }

        public static ACosh acoshOf(String fieldReference) {
            return new ACosh(Fields.field(fieldReference));
        }

        public static ACosh acoshOf(AggregationExpression expression) {
            return new ACosh(expression);
        }

        public static ACosh acoshOf(Object value) {
            return new ACosh(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$acosh";
        }
    }

    public static class ACos
    extends AbstractAggregationExpression {
        private ACos(Object value) {
            super(value);
        }

        public static ACos acosOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new ACos(Fields.field(fieldReference));
        }

        public static ACos acosOf(AggregationExpression expression) {
            return new ACos(expression);
        }

        public static ACos acosOf(Number value) {
            return new ACos(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$acos";
        }
    }

    public static class Cosh
    extends AbstractAggregationExpression {
        private Cosh(Object value) {
            super(value);
        }

        public static Cosh coshOf(String fieldReference) {
            return Cosh.coshOf(fieldReference, AngularUnit.RADIANS);
        }

        public static Cosh coshOf(String fieldReference, AngularUnit unit) {
            return Cosh.cosh(Fields.field(fieldReference), unit);
        }

        public static Cosh coshOf(AggregationExpression expression) {
            return Cosh.coshOf(expression, AngularUnit.RADIANS);
        }

        public static Cosh coshOf(AggregationExpression expression, AngularUnit unit) {
            return Cosh.cosh(expression, unit);
        }

        public static Cosh cosh(Object value) {
            return Cosh.cosh(value, AngularUnit.RADIANS);
        }

        public static Cosh cosh(Object value, AngularUnit unit) {
            if (ObjectUtils.nullSafeEquals((Object)AngularUnit.DEGREES, (Object)unit)) {
                return new Cosh(ConvertOperators.DegreesToRadians.degreesToRadians(value));
            }
            return new Cosh(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$cosh";
        }
    }

    public static class Cos
    extends AbstractAggregationExpression {
        private Cos(Object value) {
            super(value);
        }

        public static Cos cosOf(String fieldReference) {
            return Cos.cosOf(fieldReference, AngularUnit.RADIANS);
        }

        public static Cos cosOf(String fieldReference, AngularUnit unit) {
            return Cos.cos(Fields.field(fieldReference), unit);
        }

        public static Cos cosOf(AggregationExpression expression) {
            return Cos.cosOf(expression, AngularUnit.RADIANS);
        }

        public static Cos cosOf(AggregationExpression expression, AngularUnit unit) {
            return Cos.cos(expression, unit);
        }

        public static Cos cos(Object value) {
            return Cos.cos(value, AngularUnit.RADIANS);
        }

        public static Cos cos(Object value, AngularUnit unit) {
            if (ObjectUtils.nullSafeEquals((Object)AngularUnit.DEGREES, (Object)unit)) {
                return new Cos(ConvertOperators.DegreesToRadians.degreesToRadians(value));
            }
            return new Cos(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$cos";
        }
    }

    public static class ASinh
    extends AbstractAggregationExpression {
        private ASinh(Object value) {
            super(value);
        }

        public static ASinh asinhOf(String fieldReference) {
            return new ASinh(Fields.field(fieldReference));
        }

        public static ASinh asinhOf(AggregationExpression expression) {
            return new ASinh(expression);
        }

        public static ASinh asinhOf(Object value) {
            return new ASinh(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$asinh";
        }
    }

    public static class ASin
    extends AbstractAggregationExpression {
        private ASin(Object value) {
            super(value);
        }

        public static ASin asinOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new ASin(Fields.field(fieldReference));
        }

        public static ASin asinOf(AggregationExpression expression) {
            return new ASin(expression);
        }

        public static ASin asinOf(Number value) {
            return new ASin(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$asin";
        }
    }

    public static class Sinh
    extends AbstractAggregationExpression {
        private Sinh(Object value) {
            super(value);
        }

        public static Sinh sinhOf(String fieldReference) {
            return Sinh.sinhOf(fieldReference, AngularUnit.RADIANS);
        }

        public static Sinh sinhOf(String fieldReference, AngularUnit unit) {
            return Sinh.sinh(Fields.field(fieldReference), unit);
        }

        public static Sinh sinhOf(AggregationExpression expression) {
            return Sinh.sinhOf(expression, AngularUnit.RADIANS);
        }

        public static Sinh sinhOf(AggregationExpression expression, AngularUnit unit) {
            return Sinh.sinh(expression, unit);
        }

        public static Sinh sinh(Object value) {
            return Sinh.sinh(value, AngularUnit.RADIANS);
        }

        public static Sinh sinh(Object value, AngularUnit unit) {
            if (ObjectUtils.nullSafeEquals((Object)AngularUnit.DEGREES, (Object)unit)) {
                return new Sinh(ConvertOperators.DegreesToRadians.degreesToRadians(value));
            }
            return new Sinh(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$sinh";
        }
    }

    public static class Sin
    extends AbstractAggregationExpression {
        private Sin(Object value) {
            super(value);
        }

        public static Sin sinOf(String fieldReference) {
            return Sin.sinOf(fieldReference, AngularUnit.RADIANS);
        }

        public static Sin sinOf(String fieldReference, AngularUnit unit) {
            return Sin.sin(Fields.field(fieldReference), unit);
        }

        public static Sin sinOf(AggregationExpression expression) {
            return Sin.sinOf(expression, AngularUnit.RADIANS);
        }

        public static Sin sinOf(AggregationExpression expression, AngularUnit unit) {
            return Sin.sin(expression, unit);
        }

        public static Sin sin(Object value) {
            return Sin.sin(value, AngularUnit.RADIANS);
        }

        public static Sin sin(Object value, AngularUnit unit) {
            if (ObjectUtils.nullSafeEquals((Object)AngularUnit.DEGREES, (Object)unit)) {
                return new Sin(ConvertOperators.DegreesToRadians.degreesToRadians(value));
            }
            return new Sin(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$sin";
        }
    }

    public static enum AngularUnit {
        RADIANS,
        DEGREES;

    }

    public static class Integral
    extends AbstractAggregationExpression {
        private Integral(Object value) {
            super(value);
        }

        public static Integral integralOf(String fieldReference) {
            return new Integral(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static Integral integralOf(AggregationExpression expression) {
            return new Integral(Collections.singletonMap("input", expression));
        }

        public Integral unit(String unit) {
            return new Integral(this.append("unit", unit));
        }

        @Override
        protected String getMongoMethod() {
            return "$integral";
        }
    }

    public static class Derivative
    extends AbstractAggregationExpression {
        private Derivative(Object value) {
            super(value);
        }

        public static Derivative derivativeOf(String fieldReference) {
            return new Derivative(Collections.singletonMap("input", Fields.field(fieldReference)));
        }

        public static Derivative derivativeOf(AggregationExpression expression) {
            return new Derivative(Collections.singletonMap("input", expression));
        }

        public static Derivative derivativeOfValue(Number value) {
            return new Derivative(Collections.singletonMap("input", value));
        }

        public Derivative unit(String unit) {
            return new Derivative(this.append("unit", unit));
        }

        @Override
        protected String getMongoMethod() {
            return "$derivative";
        }
    }

    public static class Round
    extends AbstractAggregationExpression {
        private Round(Object value) {
            super(value);
        }

        public static Round roundValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Round(Collections.singletonList(Fields.field(fieldReference)));
        }

        public static Round roundValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Round(Collections.singletonList(expression));
        }

        public static Round round(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Round(Collections.singletonList(value));
        }

        public Round place(int place) {
            return new Round(this.append(place));
        }

        public Round placeOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Round(this.append(expression));
        }

        public Round placeOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "fieldReference must not be null");
            return new Round(this.append(Fields.field(fieldReference)));
        }

        @Override
        protected String getMongoMethod() {
            return "$round";
        }
    }

    public static class Trunc
    extends AbstractAggregationExpression {
        private Trunc(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$trunc";
        }

        public static Trunc truncValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Trunc(Fields.field(fieldReference));
        }

        public static Trunc truncValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Trunc(expression);
        }

        public static Trunc truncValueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Trunc(value);
        }
    }

    public static class Subtract
    extends AbstractAggregationExpression {
        private Subtract(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$subtract";
        }

        public static Subtract valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Subtract(Subtract.asFields(fieldReference));
        }

        public static Subtract valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Subtract(Collections.singletonList(expression));
        }

        public static Subtract valueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Subtract(Collections.singletonList(value));
        }

        public Subtract subtract(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Subtract(this.append(Fields.field(fieldReference)));
        }

        public Subtract subtract(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Subtract(this.append(expression));
        }

        public Subtract subtract(Number value) {
            return new Subtract(this.append(value));
        }
    }

    public static class Sqrt
    extends AbstractAggregationExpression {
        private Sqrt(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$sqrt";
        }

        public static Sqrt sqrtOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Sqrt(Fields.field(fieldReference));
        }

        public static Sqrt sqrtOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Sqrt(expression);
        }

        public static Sqrt sqrtOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Sqrt(value);
        }
    }

    public static class Pow
    extends AbstractAggregationExpression {
        private Pow(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$pow";
        }

        public static Pow valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Pow(Pow.asFields(fieldReference));
        }

        public static Pow valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Pow(Collections.singletonList(expression));
        }

        public static Pow valueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Pow(Collections.singletonList(value));
        }

        public Pow pow(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Pow(this.append(Fields.field(fieldReference)));
        }

        public Pow pow(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Pow(this.append(expression));
        }

        public Pow pow(Number value) {
            return new Pow(this.append(value));
        }
    }

    public static class Multiply
    extends AbstractAggregationExpression {
        private Multiply(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$multiply";
        }

        public static Multiply valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Multiply(Multiply.asFields(fieldReference));
        }

        public static Multiply valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Multiply(Collections.singletonList(expression));
        }

        public static Multiply valueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Multiply(Collections.singletonList(value));
        }

        public Multiply multiplyBy(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Multiply(this.append(Fields.field(fieldReference)));
        }

        public Multiply multiplyBy(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Multiply(this.append(expression));
        }

        public Multiply multiplyBy(Number value) {
            return new Multiply(this.append(value));
        }
    }

    public static class Mod
    extends AbstractAggregationExpression {
        private Mod(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$mod";
        }

        public static Mod valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Mod(Mod.asFields(fieldReference));
        }

        public static Mod valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Mod(Collections.singletonList(expression));
        }

        public static Mod valueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Mod(Collections.singletonList(value));
        }

        public Mod mod(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Mod(this.append(Fields.field(fieldReference)));
        }

        public Mod mod(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Mod(this.append(expression));
        }

        public Mod mod(Number base) {
            return new Mod(this.append(base));
        }
    }

    public static class Log10
    extends AbstractAggregationExpression {
        private Log10(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$log10";
        }

        public static Log10 log10ValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Log10(Fields.field(fieldReference));
        }

        public static Log10 log10ValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Log10(expression);
        }

        public static Log10 log10ValueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Log10(value);
        }
    }

    public static class Log
    extends AbstractAggregationExpression {
        private Log(List<?> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$log";
        }

        public static Log valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Log(Log.asFields(fieldReference));
        }

        public static Log valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Log(Collections.singletonList(expression));
        }

        public static Log valueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Log(Collections.singletonList(value));
        }

        public Log log(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Log(this.append(Fields.field(fieldReference)));
        }

        public Log log(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Log(this.append(expression));
        }

        public Log log(Number base) {
            return new Log(this.append(base));
        }
    }

    public static class Ln
    extends AbstractAggregationExpression {
        private Ln(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$ln";
        }

        public static Ln lnValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Ln(Fields.field(fieldReference));
        }

        public static Ln lnValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Ln(expression);
        }

        public static Ln lnValueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Ln(value);
        }
    }

    public static class Floor
    extends AbstractAggregationExpression {
        private Floor(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$floor";
        }

        public static Floor floorValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Floor(Fields.field(fieldReference));
        }

        public static Floor floorValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Floor(expression);
        }

        public static Floor floorValueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Floor(value);
        }
    }

    public static class Exp
    extends AbstractAggregationExpression {
        private Exp(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$exp";
        }

        public static Exp expValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Exp(Fields.field(fieldReference));
        }

        public static Exp expValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Exp(expression);
        }

        public static Exp expValueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Exp(value);
        }
    }

    public static class Divide
    extends AbstractAggregationExpression {
        private Divide(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$divide";
        }

        public static Divide valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Divide(Divide.asFields(fieldReference));
        }

        public static Divide valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Divide(Collections.singletonList(expression));
        }

        public static Divide valueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Divide(Collections.singletonList(value));
        }

        public Divide divideBy(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Divide(this.append(Fields.field(fieldReference)));
        }

        public Divide divideBy(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Divide(this.append(expression));
        }

        public Divide divideBy(Number value) {
            return new Divide(this.append(value));
        }
    }

    public static class Ceil
    extends AbstractAggregationExpression {
        private Ceil(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$ceil";
        }

        public static Ceil ceilValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Ceil(Fields.field(fieldReference));
        }

        public static Ceil ceilValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Ceil(expression);
        }

        public static Ceil ceilValueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Ceil(value);
        }
    }

    public static class Add
    extends AbstractAggregationExpression {
        protected Add(List<?> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$add";
        }

        public static Add valueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Add(Add.asFields(fieldReference));
        }

        public static Add valueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Add(Collections.singletonList(expression));
        }

        public static Add valueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Add(Collections.singletonList(value));
        }

        public Add add(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Add(this.append(Fields.field(fieldReference)));
        }

        public Add add(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Add(this.append(expression));
        }

        public Add add(Number value) {
            return new Add(this.append(value));
        }
    }

    public static class Abs
    extends AbstractAggregationExpression {
        private Abs(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$abs";
        }

        public static Abs absoluteValueOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Abs(Fields.field(fieldReference));
        }

        public static Abs absoluteValueOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Abs(expression);
        }

        public static Abs absoluteValueOf(Number value) {
            Assert.notNull((Object)value, "Value must not be null");
            return new Abs(value);
        }
    }
}

