/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;

public class BooleanOperators {
    public static BooleanOperatorFactory valueOf(String fieldReference) {
        return new BooleanOperatorFactory(fieldReference);
    }

    public static BooleanOperatorFactory valueOf(AggregationExpression fieldReference) {
        return new BooleanOperatorFactory(fieldReference);
    }

    public static Not not(String fieldReference) {
        return Not.not(fieldReference);
    }

    public static Not not(AggregationExpression expression) {
        return Not.not(expression);
    }

    public static class BooleanOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public BooleanOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public BooleanOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            this.fieldReference = null;
            this.expression = expression;
        }

        public And and(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return this.createAnd().andExpression(expression);
        }

        public And and(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return this.createAnd().andField(fieldReference);
        }

        private And createAnd() {
            return this.usesFieldRef() ? And.and(Fields.field(this.fieldReference)) : And.and(this.expression);
        }

        public Or or(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return this.createOr().orExpression(expression);
        }

        public Or or(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return this.createOr().orField(fieldReference);
        }

        private Or createOr() {
            return this.usesFieldRef() ? Or.or(Fields.field(this.fieldReference)) : Or.or(this.expression);
        }

        public Not not() {
            return this.usesFieldRef() ? Not.not(this.fieldReference) : Not.not(this.expression);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }

    public static class Not
    extends AbstractAggregationExpression {
        private Not(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$not";
        }

        public static Not not(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Not(Not.asFields(fieldReference));
        }

        public static Not not(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Not(Collections.singletonList(expression));
        }
    }

    public static class Or
    extends AbstractAggregationExpression {
        private Or(List<?> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$or";
        }

        public static Or or(Object ... expressions) {
            Assert.notNull((Object)expressions, "Expressions must not be null");
            return new Or(Arrays.asList(expressions));
        }

        public Or orExpression(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new Or(this.append(expression));
        }

        public Or orField(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new Or(this.append(Fields.field(fieldReference)));
        }

        public Or orValue(Object value) {
            Assert.notNull(value, "Value must not be null");
            return new Or(this.append(value));
        }
    }

    public static class And
    extends AbstractAggregationExpression {
        private And(List<?> values) {
            super(values);
        }

        @Override
        protected String getMongoMethod() {
            return "$and";
        }

        public static And and(Object ... expressions) {
            return new And(Arrays.asList(expressions));
        }

        public And andExpression(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new And(this.append(expression));
        }

        public And andField(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            return new And(this.append(Fields.field(fieldReference)));
        }

        public And andValue(Object value) {
            Assert.notNull(value, "Value must not be null");
            return new And(this.append(value));
        }
    }
}

