/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collections;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Fields;

public class DocumentOperators {
    public static Rank rank() {
        return new Rank();
    }

    public static DenseRank denseRank() {
        return new DenseRank();
    }

    public static DocumentOperatorsFactory valueOf(String fieldReference) {
        return new DocumentOperatorsFactory(fieldReference);
    }

    public static DocumentOperatorsFactory valueOf(AggregationExpression expression) {
        return new DocumentOperatorsFactory(expression);
    }

    public static DocumentNumber documentNumber() {
        return new DocumentNumber();
    }

    public static class Rank
    implements AggregationExpression {
        @Override
        public Document toDocument(AggregationOperationContext context) {
            return new Document("$rank", new Document());
        }
    }

    public static class DenseRank
    implements AggregationExpression {
        @Override
        public Document toDocument(AggregationOperationContext context) {
            return new Document("$denseRank", new Document());
        }
    }

    public static class DocumentOperatorsFactory {
        private final Object target;

        public DocumentOperatorsFactory(Object target) {
            this.target = target;
        }

        public Shift shift(int by) {
            Shift shift = this.usesExpression() ? Shift.shift((AggregationExpression)this.target) : Shift.shift(this.target.toString());
            return shift.by(by);
        }

        private boolean usesExpression() {
            return this.target instanceof AggregationExpression;
        }
    }

    public static class DocumentNumber
    implements AggregationExpression {
        @Override
        public Document toDocument(AggregationOperationContext context) {
            return new Document("$documentNumber", new Document());
        }
    }

    public static class Shift
    extends AbstractAggregationExpression {
        private Shift(Object value) {
            super(value);
        }

        public static Shift shift(String fieldReference) {
            return new Shift(Collections.singletonMap("output", Fields.field(fieldReference)));
        }

        public static Shift shift(AggregationExpression expression) {
            return new Shift(Collections.singletonMap("output", expression));
        }

        public Shift by(int shiftBy) {
            return new Shift(this.append("by", shiftBy));
        }

        public Shift defaultTo(Object value) {
            return new Shift(this.append("default", value));
        }

        public Shift defaultToValueOf(AggregationExpression expression) {
            return this.defaultTo(expression);
        }

        @Override
        protected String getMongoMethod() {
            return "$shift";
        }
    }
}

