/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.util.Assert;

public class LimitOperation
implements AggregationOperation {
    private final long maxElements;

    public LimitOperation(long maxElements) {
        Assert.isTrue(maxElements >= 0L, "Maximum number of elements must be greater or equal to zero");
        this.maxElements = maxElements;
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return new Document(this.getOperator(), this.maxElements);
    }

    @Override
    public String getOperator() {
        return "$limit";
    }
}

