/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.util.Assert;

public class ReplaceRootOperation
implements FieldsExposingAggregationOperation {
    private final Replacement replacement;

    public ReplaceRootOperation(Field field) {
        this(new FieldReplacement(field));
    }

    public ReplaceRootOperation(AggregationExpression aggregationExpression) {
        this(new AggregationExpressionReplacement(aggregationExpression));
    }

    public ReplaceRootOperation(Replacement replacement) {
        Assert.notNull((Object)replacement, "Replacement must not be null");
        this.replacement = replacement;
    }

    public static ReplaceRootOperationBuilder builder() {
        return new ReplaceRootOperationBuilder();
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return new Document("$replaceRoot", new Document("newRoot", this.getReplacement().toDocumentExpression(context)));
    }

    @Override
    public String getOperator() {
        return "$replaceRoot";
    }

    @Override
    public ExposedFields getFields() {
        return ExposedFields.from(new ExposedFields.ExposedField[0]);
    }

    protected Replacement getReplacement() {
        return this.replacement;
    }

    private static class FieldReplacement
    implements Replacement {
        private final Field field;

        protected FieldReplacement(Field field) {
            Assert.notNull((Object)field, "Field must not be null");
            this.field = field;
        }

        @Override
        public Object toDocumentExpression(AggregationOperationContext context) {
            return context.getReference(this.field).toString();
        }
    }

    public static interface Replacement {
        public Object toDocumentExpression(AggregationOperationContext var1);
    }

    private static class AggregationExpressionReplacement
    implements Replacement {
        private final AggregationExpression aggregationExpression;

        protected AggregationExpressionReplacement(AggregationExpression aggregationExpression) {
            Assert.notNull((Object)aggregationExpression, "AggregationExpression must not be null");
            this.aggregationExpression = aggregationExpression;
        }

        @Override
        public Document toDocumentExpression(AggregationOperationContext context) {
            return this.aggregationExpression.toDocument(context);
        }
    }

    public static class ReplaceRootOperationBuilder {
        public ReplaceRootOperation withValueOf(String fieldName) {
            return new ReplaceRootOperation(Fields.field(fieldName));
        }

        public ReplaceRootOperation withValueOf(AggregationExpression aggregationExpression) {
            return new ReplaceRootOperation(aggregationExpression);
        }

        public ReplaceRootDocumentOperation withDocument() {
            return new ReplaceRootDocumentOperation();
        }

        public ReplaceRootOperation withDocument(Document document) {
            Assert.notNull((Object)document, "Document must not be null");
            return new ReplaceRootDocumentOperation().andValuesOf(document);
        }
    }

    private static class ExpressionFieldContributor
    extends FieldContributorSupport {
        private final AggregationExpression aggregationExpression;

        public ExpressionFieldContributor(Field field, AggregationExpression aggregationExpression) {
            super(field);
            Assert.notNull((Object)aggregationExpression, "AggregationExpression must not be null");
            this.aggregationExpression = aggregationExpression;
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            return new Document(this.getField().getTarget(), this.aggregationExpression.toDocument(context));
        }
    }

    private static class ValueFieldContributor
    extends FieldContributorSupport {
        private final Object value;

        public ValueFieldContributor(Field field, Object value) {
            super(field);
            Assert.notNull(value, "Value must not be null");
            this.value = value;
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            Document document = new Document("$set", this.value);
            return new Document(this.getField().getTarget(), context.getMappedObject(document).get("$set"));
        }
    }

    private static abstract class FieldContributorSupport
    implements ReplacementContributor {
        private final ExposedFields.ExposedField field;

        public FieldContributorSupport(Field field) {
            Assert.notNull((Object)field, "Field must not be null");
            this.field = new ExposedFields.ExposedField(field, true);
        }

        public ExposedFields.ExposedField getField() {
            return this.field;
        }
    }

    private static class DocumentContributor
    implements ReplacementContributor {
        private final Object value;

        public DocumentContributor(Object value) {
            Assert.notNull(value, "Value must not be null");
            this.value = value;
        }

        @Override
        public Document toDocument(AggregationOperationContext context) {
            Document document = new Document("$set", this.value);
            return (Document)context.getMappedObject(document).get("$set");
        }
    }

    private static interface ReplacementContributor
    extends AggregationExpression {
        @Override
        public Document toDocument(AggregationOperationContext var1);
    }

    private static class ReplacementDocument
    implements Replacement {
        private final Collection<ReplacementContributor> replacements;

        protected ReplacementDocument() {
            this.replacements = new ArrayList<ReplacementContributor>();
        }

        protected ReplacementDocument(ReplacementContributor contributor) {
            Assert.notNull((Object)contributor, "ReplacementContributor must not be null");
            this.replacements = Collections.singleton(contributor);
        }

        private ReplacementDocument(Collection<ReplacementContributor> replacements) {
            this.replacements = replacements;
        }

        public static ReplacementDocument valueOf(Object value) {
            return new ReplacementDocument(new DocumentContributor(value));
        }

        public static ReplacementDocument forExpression(String field, AggregationExpression aggregationExpression) {
            return new ReplacementDocument(new ExpressionFieldContributor(Fields.field(field), aggregationExpression));
        }

        public static ReplacementDocument forSingleValue(String field, Object value) {
            return new ReplacementDocument(new ValueFieldContributor(Fields.field(field), value));
        }

        @Override
        public Document toDocumentExpression(AggregationOperationContext context) {
            Document document = new Document();
            for (ReplacementContributor replacement : this.replacements) {
                document.putAll(replacement.toDocument(context));
            }
            return document;
        }

        public ReplacementDocument extendWith(ReplacementDocument extension) {
            Assert.notNull((Object)extension, "ReplacementDocument must not be null");
            ReplacementDocument replacementDocument = new ReplacementDocument();
            ArrayList<ReplacementContributor> replacements = new ArrayList<ReplacementContributor>(this.replacements.size() + extension.replacements.size());
            replacements.addAll(this.replacements);
            replacements.addAll(extension.replacements);
            return new ReplacementDocument(replacements);
        }
    }

    public static class ReplaceRootDocumentOperationBuilder {
        private final ReplaceRootDocumentOperation currentOperation;
        private final Object value;

        protected ReplaceRootDocumentOperationBuilder(ReplaceRootDocumentOperation currentOperation, Object value) {
            Assert.notNull((Object)currentOperation, "Current ReplaceRootDocumentOperation must not be null");
            Assert.notNull(value, "Value must not be null");
            this.currentOperation = currentOperation;
            this.value = value;
        }

        public ReplaceRootDocumentOperation as(String fieldName) {
            if (this.value instanceof AggregationExpression) {
                return new ReplaceRootDocumentOperation(this.currentOperation, ReplacementDocument.forExpression(fieldName, (AggregationExpression)this.value));
            }
            return new ReplaceRootDocumentOperation(this.currentOperation, ReplacementDocument.forSingleValue(fieldName, this.value));
        }
    }

    public static class ReplaceRootDocumentOperation
    extends ReplaceRootOperation {
        private static final ReplacementDocument EMPTY = new ReplacementDocument();
        private final ReplacementDocument current;

        public ReplaceRootDocumentOperation() {
            this(EMPTY);
        }

        private ReplaceRootDocumentOperation(ReplacementDocument replacementDocument) {
            super(replacementDocument);
            this.current = replacementDocument;
        }

        protected ReplaceRootDocumentOperation(ReplaceRootDocumentOperation currentOperation, ReplacementDocument extension) {
            this(currentOperation.current.extendWith(extension));
        }

        public ReplaceRootDocumentOperationBuilder and(AggregationExpression aggregationExpression) {
            return new ReplaceRootDocumentOperationBuilder(this, aggregationExpression);
        }

        public ReplaceRootDocumentOperationBuilder andValue(Object value) {
            return new ReplaceRootDocumentOperationBuilder(this, value);
        }

        public ReplaceRootDocumentOperation andValuesOf(Object value) {
            return new ReplaceRootDocumentOperation(this, ReplacementDocument.valueOf(value));
        }
    }
}

