/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;

public class SetOperators {
    public static SetOperatorFactory arrayAsSet(String fieldReference) {
        return new SetOperatorFactory(fieldReference);
    }

    public static SetOperatorFactory arrayAsSet(AggregationExpression expression) {
        return new SetOperatorFactory(expression);
    }

    public static class SetOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public SetOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, "FieldReference must not be null");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public SetOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            this.fieldReference = null;
            this.expression = expression;
        }

        public SetEquals isEqualTo(String ... arrayReferences) {
            return this.createSetEquals().isEqualTo(arrayReferences);
        }

        public SetEquals isEqualTo(AggregationExpression ... expressions) {
            return this.createSetEquals().isEqualTo(expressions);
        }

        private SetEquals createSetEquals() {
            return this.usesFieldRef() ? SetEquals.arrayAsSet(this.fieldReference) : SetEquals.arrayAsSet(this.expression);
        }

        public SetIntersection intersects(String ... arrayReferences) {
            return this.createSetIntersection().intersects(arrayReferences);
        }

        public SetIntersection intersects(AggregationExpression ... expressions) {
            return this.createSetIntersection().intersects(expressions);
        }

        private SetIntersection createSetIntersection() {
            return this.usesFieldRef() ? SetIntersection.arrayAsSet(this.fieldReference) : SetIntersection.arrayAsSet(this.expression);
        }

        public SetUnion union(String ... arrayReferences) {
            return this.createSetUnion().union(arrayReferences);
        }

        public SetUnion union(AggregationExpression ... expressions) {
            return this.createSetUnion().union(expressions);
        }

        private SetUnion createSetUnion() {
            return this.usesFieldRef() ? SetUnion.arrayAsSet(this.fieldReference) : SetUnion.arrayAsSet(this.expression);
        }

        public SetDifference differenceTo(String arrayReference) {
            return this.createSetDifference().differenceTo(arrayReference);
        }

        public SetDifference differenceTo(AggregationExpression expression) {
            return this.createSetDifference().differenceTo(expression);
        }

        private SetDifference createSetDifference() {
            return this.usesFieldRef() ? SetDifference.arrayAsSet(this.fieldReference) : SetDifference.arrayAsSet(this.expression);
        }

        public SetIsSubset isSubsetOf(String arrayReference) {
            return this.createSetIsSubset().isSubsetOf(arrayReference);
        }

        public SetIsSubset isSubsetOf(AggregationExpression expression) {
            return this.createSetIsSubset().isSubsetOf(expression);
        }

        private SetIsSubset createSetIsSubset() {
            return this.usesFieldRef() ? SetIsSubset.arrayAsSet(this.fieldReference) : SetIsSubset.arrayAsSet(this.expression);
        }

        public AnyElementTrue anyElementTrue() {
            return this.usesFieldRef() ? AnyElementTrue.arrayAsSet(this.fieldReference) : AnyElementTrue.arrayAsSet(this.expression);
        }

        public AllElementsTrue allElementsTrue() {
            return this.usesFieldRef() ? AllElementsTrue.arrayAsSet(this.fieldReference) : AllElementsTrue.arrayAsSet(this.expression);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }

    public static class AllElementsTrue
    extends AbstractAggregationExpression {
        private AllElementsTrue(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$allElementsTrue";
        }

        public static AllElementsTrue arrayAsSet(String arrayReference) {
            Assert.notNull((Object)arrayReference, "ArrayReference must not be null");
            return new AllElementsTrue(AllElementsTrue.asFields(arrayReference));
        }

        public static AllElementsTrue arrayAsSet(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new AllElementsTrue(Collections.singletonList(expression));
        }

        public AllElementsTrue allElementsTrue() {
            return this;
        }
    }

    public static class AnyElementTrue
    extends AbstractAggregationExpression {
        private AnyElementTrue(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$anyElementTrue";
        }

        public static AnyElementTrue arrayAsSet(String arrayReference) {
            Assert.notNull((Object)arrayReference, "ArrayReference must not be null");
            return new AnyElementTrue(AnyElementTrue.asFields(arrayReference));
        }

        public static AnyElementTrue arrayAsSet(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new AnyElementTrue(Collections.singletonList(expression));
        }

        public AnyElementTrue anyElementTrue() {
            return this;
        }
    }

    public static class SetIsSubset
    extends AbstractAggregationExpression {
        private SetIsSubset(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$setIsSubset";
        }

        public static SetIsSubset arrayAsSet(String arrayReference) {
            Assert.notNull((Object)arrayReference, "ArrayReference must not be null");
            return new SetIsSubset(SetIsSubset.asFields(arrayReference));
        }

        public static SetIsSubset arrayAsSet(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new SetIsSubset(Collections.singletonList(expression));
        }

        public SetIsSubset isSubsetOf(String arrayReference) {
            Assert.notNull((Object)arrayReference, "ArrayReference must not be null");
            return new SetIsSubset(this.append(Fields.field(arrayReference)));
        }

        public SetIsSubset isSubsetOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new SetIsSubset(this.append(expression));
        }
    }

    public static class SetDifference
    extends AbstractAggregationExpression {
        private SetDifference(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$setDifference";
        }

        public static SetDifference arrayAsSet(String arrayReference) {
            Assert.notNull((Object)arrayReference, "ArrayReference must not be null");
            return new SetDifference(SetDifference.asFields(arrayReference));
        }

        public static SetDifference arrayAsSet(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new SetDifference(Collections.singletonList(expression));
        }

        public SetDifference differenceTo(String arrayReference) {
            Assert.notNull((Object)arrayReference, "ArrayReference must not be null");
            return new SetDifference(this.append(Fields.field(arrayReference)));
        }

        public SetDifference differenceTo(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new SetDifference(this.append(expression));
        }
    }

    public static class SetUnion
    extends AbstractAggregationExpression {
        private SetUnion(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$setUnion";
        }

        public static SetUnion arrayAsSet(String arrayReference) {
            Assert.notNull((Object)arrayReference, "ArrayReference must not be null");
            return new SetUnion(SetUnion.asFields(arrayReference));
        }

        public static SetUnion arrayAsSet(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new SetUnion(Collections.singletonList(expression));
        }

        public SetUnion union(String ... arrayReferences) {
            Assert.notNull((Object)arrayReferences, "ArrayReferences must not be null");
            return new SetUnion(this.append(SetUnion.asFields(arrayReferences)));
        }

        public SetUnion union(AggregationExpression ... expressions) {
            Assert.notNull((Object)expressions, "Expressions must not be null");
            return new SetUnion(this.append(Arrays.asList(expressions)));
        }
    }

    public static class SetIntersection
    extends AbstractAggregationExpression {
        private SetIntersection(List<?> arrays) {
            super(arrays);
        }

        @Override
        protected String getMongoMethod() {
            return "$setIntersection";
        }

        public static SetIntersection arrayAsSet(String arrayReference) {
            Assert.notNull((Object)arrayReference, "ArrayReference must not be null");
            return new SetIntersection(SetIntersection.asFields(arrayReference));
        }

        public static SetIntersection arrayAsSet(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new SetIntersection(Collections.singletonList(expression));
        }

        public SetIntersection intersects(String ... arrayReferences) {
            Assert.notNull((Object)arrayReferences, "ArrayReferences must not be null");
            return new SetIntersection(this.append(SetIntersection.asFields(arrayReferences)));
        }

        public SetIntersection intersects(AggregationExpression ... expressions) {
            Assert.notNull((Object)expressions, "Expressions must not be null");
            return new SetIntersection(this.append(Arrays.asList(expressions)));
        }
    }

    public static class SetEquals
    extends AbstractAggregationExpression {
        private SetEquals(List<?> arrays) {
            super(arrays);
        }

        @Override
        protected String getMongoMethod() {
            return "$setEquals";
        }

        public static SetEquals arrayAsSet(String arrayReference) {
            Assert.notNull((Object)arrayReference, "ArrayReference must not be null");
            return new SetEquals(SetEquals.asFields(arrayReference));
        }

        public static SetEquals arrayAsSet(AggregationExpression expression) {
            Assert.notNull((Object)expression, "Expression must not be null");
            return new SetEquals(Collections.singletonList(expression));
        }

        public SetEquals isEqualTo(String ... arrayReferences) {
            Assert.notNull((Object)arrayReferences, "ArrayReferences must not be null");
            return new SetEquals(this.append(Fields.fields(arrayReferences).asList()));
        }

        public SetEquals isEqualTo(AggregationExpression ... expressions) {
            Assert.notNull((Object)expressions, "Expressions must not be null");
            return new SetEquals(this.append(Arrays.asList(expressions)));
        }

        public SetEquals isEqualTo(Object[] array) {
            Assert.notNull((Object)array, "Array must not be null");
            return new SetEquals(this.append(array));
        }
    }
}

